/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.webhooks;

import com.github.tomakehurst.wiremock.common.DataTruncationSettings;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.common.ProhibitedNetworkAddressException;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.PostServeAction;
import com.github.tomakehurst.wiremock.extension.ServeEventListener;
import com.github.tomakehurst.wiremock.extension.WireMockServices;
import com.github.tomakehurst.wiremock.extension.responsetemplating.TemplateEngine;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.ImmutableRequest;
import com.github.tomakehurst.wiremock.http.LoggedResponse;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.client.HttpClient;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.wiremock.webhooks.WebhookDefinition;
import org.wiremock.webhooks.WebhookTransformer;

public class Webhooks
extends PostServeAction
implements ServeEventListener {
    private final ScheduledExecutorService scheduler;
    private final HttpClient httpClient;
    private final List<WebhookTransformer> transformers;
    private final TemplateEngine templateEngine;
    private final DataTruncationSettings dataTruncationSettings;

    public Webhooks(WireMockServices wireMockServices, ScheduledExecutorService scheduler, List<WebhookTransformer> transformers) {
        this.scheduler = scheduler;
        this.httpClient = wireMockServices.getDefaultHttpClient();
        this.transformers = transformers;
        this.templateEngine = wireMockServices.getTemplateEngine();
        this.dataTruncationSettings = wireMockServices.getOptions().getDataTruncationSettings();
    }

    @Override
    public String getName() {
        return "webhook";
    }

    @Override
    public void afterComplete(ServeEvent serveEvent, Parameters parameters) {
        this.triggerWebhook(serveEvent, parameters);
    }

    @Override
    public void doAction(ServeEvent serveEvent, Admin admin, Parameters parameters) {
        this.triggerWebhook(serveEvent, parameters);
    }

    private void triggerWebhook(ServeEvent serveEvent, Parameters parameters) {
        Request request2;
        WebhookDefinition definition;
        Notifier notifier = LocalNotifier.notifier();
        try {
            definition = WebhookDefinition.from(parameters);
            for (WebhookTransformer transformer : this.transformers) {
                definition = transformer.transform(serveEvent, definition);
            }
            definition = this.applyTemplating(definition, serveEvent);
            request2 = Webhooks.buildRequest(definition);
            serveEvent.appendSubEvent("WEBHOOK_REQUEST", LoggedRequest.createFrom(request2));
        }
        catch (Exception e) {
            String msg = "Exception thrown while configuring webhook";
            LocalNotifier.notifier().error("Exception thrown while configuring webhook", e);
            serveEvent.appendSubEvent(SubEvent.error("Exception thrown while configuring webhook: " + e.getMessage()));
            return;
        }
        WebhookDefinition finalDefinition = definition;
        this.scheduler.schedule(() -> {
            try {
                Response response = this.httpClient.execute(request2);
                notifier.info(String.format("Webhook %s request to %s returned status %s\n\n%s", finalDefinition.getMethod(), finalDefinition.getUrl(), response.getStatus(), response.getBodyAsString()));
                serveEvent.appendSubEvent("WEBHOOK_RESPONSE", LoggedResponse.from(response, this.dataTruncationSettings.getMaxResponseBodySize()));
            }
            catch (ProhibitedNetworkAddressException e) {
                String msg = String.format("The target webhook address %s specified by stub %s is denied in WireMock's configuration.", finalDefinition.getUrl(), ParameterUtils.getFirstNonNull(serveEvent.getStubMapping().getName(), serveEvent.getStubMapping().getId(), "<no name or id>"));
                notifier.error(msg);
                serveEvent.appendSubEvent(SubEvent.error(msg));
            }
            catch (Exception e) {
                String msg = String.format("Failed to fire webhook %s %s", finalDefinition.getMethod(), finalDefinition.getUrl());
                notifier.error(msg, e);
                serveEvent.appendSubEvent(SubEvent.error(msg + ": " + e.getMessage()));
            }
        }, finalDefinition.getDelaySampleMillis(), TimeUnit.MILLISECONDS);
    }

    private WebhookDefinition applyTemplating(WebhookDefinition webhookDefinition, ServeEvent serveEvent) {
        HashMap<String, Object> model = new HashMap<String, Object>(this.templateEngine.buildModelForRequest(serveEvent));
        model.put("parameters", webhookDefinition.getExtraParameters() != null ? webhookDefinition.getExtraParameters() : Collections.emptyMap());
        model.put("originalRequest", model.get("request"));
        model.remove("request");
        WebhookDefinition renderedWebhookDefinition = webhookDefinition.withUrl(this.renderTemplate(model, webhookDefinition.getUrl())).withMethod(this.renderTemplate(model, webhookDefinition.getMethod())).withHeaders(webhookDefinition.getHeaders().all().stream().map(header -> new HttpHeader(header.key(), (Collection<String>)header.values().stream().map(value -> this.renderTemplate(model, (String)value)).collect(Collectors.toList()))).collect(Collectors.toList()));
        if (webhookDefinition.getBody() != null) {
            renderedWebhookDefinition = webhookDefinition.withBody(this.renderTemplate(model, webhookDefinition.getBody()));
        }
        return renderedWebhookDefinition;
    }

    private String renderTemplate(Object context, String value) {
        return this.templateEngine.getUncachedTemplate(value).apply(context);
    }

    private static Request buildRequest(WebhookDefinition definition) {
        ImmutableRequest.Builder requestBuilder = ImmutableRequest.create().withMethod(definition.getRequestMethod()).withAbsoluteUrl(definition.getUrl()).withHeaders(definition.getHeaders());
        if (definition.getRequestMethod().hasEntity() && definition.hasBody()) {
            requestBuilder.withBody(definition.getBinaryBody());
        }
        return requestBuilder.build();
    }

    @Override
    public boolean applyGlobally() {
        return false;
    }

    public static WebhookDefinition webhook() {
        return new WebhookDefinition();
    }
}

