/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;
import wiremock.jakarta.servlet.http.Cookie;
import wiremock.org.hamcrest.Matcher;
import wiremock.org.hamcrest.MatcherAssert;

public class CookieResultMatchers {
    protected CookieResultMatchers() {
    }

    public ResultMatcher value(String name, Matcher<? super String> matcher) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            MatcherAssert.assertThat("Response cookie '" + name + "'", cookie.getValue(), matcher);
        };
    }

    public ResultMatcher value(String name, String expectedValue) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            AssertionErrors.assertEquals("Response cookie", expectedValue, cookie.getValue());
        };
    }

    public ResultMatcher exists(String name) {
        return result -> CookieResultMatchers.getCookie(result, name);
    }

    public ResultMatcher doesNotExist(String name) {
        return result -> {
            Cookie cookie = result.getResponse().getCookie(name);
            AssertionErrors.assertNull("Unexpected cookie with name '" + name + "'", cookie);
        };
    }

    public ResultMatcher maxAge(String name, Matcher<? super Integer> matcher) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            MatcherAssert.assertThat("Response cookie '" + name + "' maxAge", cookie.getMaxAge(), matcher);
        };
    }

    public ResultMatcher maxAge(String name, int maxAge) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            AssertionErrors.assertEquals("Response cookie '" + name + "' maxAge", maxAge, cookie.getMaxAge());
        };
    }

    public ResultMatcher path(String name, Matcher<? super String> matcher) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            MatcherAssert.assertThat("Response cookie '" + name + "' path", cookie.getPath(), matcher);
        };
    }

    public ResultMatcher path(String name, String path) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            AssertionErrors.assertEquals("Response cookie '" + name + "' path", path, cookie.getPath());
        };
    }

    public ResultMatcher domain(String name, Matcher<? super String> matcher) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            MatcherAssert.assertThat("Response cookie '" + name + "' domain", cookie.getDomain(), matcher);
        };
    }

    public ResultMatcher domain(String name, String domain) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            AssertionErrors.assertEquals("Response cookie '" + name + "' domain", domain, cookie.getDomain());
        };
    }

    public ResultMatcher sameSite(String name, Matcher<? super String> matcher) {
        return this.attribute(name, "SameSite", matcher);
    }

    public ResultMatcher sameSite(String name, String sameSite) {
        return this.attribute(name, "SameSite", sameSite);
    }

    public ResultMatcher comment(String name, Matcher<? super String> matcher) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            MatcherAssert.assertThat("Response cookie '" + name + "' comment", cookie.getComment(), matcher);
        };
    }

    public ResultMatcher comment(String name, String comment) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            AssertionErrors.assertEquals("Response cookie '" + name + "' comment", comment, cookie.getComment());
        };
    }

    public ResultMatcher version(String name, Matcher<? super Integer> matcher) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            MatcherAssert.assertThat("Response cookie '" + name + "' version", cookie.getVersion(), matcher);
        };
    }

    public ResultMatcher version(String name, int version) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            AssertionErrors.assertEquals("Response cookie '" + name + "' version", version, cookie.getVersion());
        };
    }

    public ResultMatcher secure(String name, boolean secure) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            AssertionErrors.assertEquals("Response cookie '" + name + "' secure", secure, cookie.getSecure());
        };
    }

    public ResultMatcher httpOnly(String name, boolean httpOnly) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            AssertionErrors.assertEquals("Response cookie '" + name + "' httpOnly", httpOnly, cookie.isHttpOnly());
        };
    }

    public ResultMatcher attribute(String cookieName, String cookieAttribute, Matcher<? super String> matcher) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, cookieName);
            String attribute = cookie.getAttribute(cookieAttribute);
            AssertionErrors.assertNotNull("Response cookie '" + cookieName + "' doesn't have attribute '" + cookieAttribute + "'", attribute);
            MatcherAssert.assertThat("Response cookie '" + cookieName + "' attribute '" + cookieAttribute + "'", attribute, matcher);
        };
    }

    public ResultMatcher attribute(String cookieName, String cookieAttribute, String attributeValue) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, cookieName);
            AssertionErrors.assertEquals("Response cookie '" + cookieName + "' attribute '" + cookieAttribute + "'", attributeValue, cookie.getAttribute(cookieAttribute));
        };
    }

    private static Cookie getCookie(MvcResult result, String name) {
        Cookie cookie = result.getResponse().getCookie(name);
        AssertionErrors.assertNotNull("No cookie with name '" + name + "'", cookie);
        return cookie;
    }
}

