/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.springframework.http.CacheControl;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.reactive.server.ExchangeResult;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.util.CollectionUtils;
import wiremock.org.hamcrest.Matcher;
import wiremock.org.hamcrest.MatcherAssert;

public class HeaderAssertions {
    private final ExchangeResult exchangeResult;
    private final WebTestClient.ResponseSpec responseSpec;

    HeaderAssertions(ExchangeResult result, WebTestClient.ResponseSpec spec) {
        this.exchangeResult = result;
        this.responseSpec = spec;
    }

    public WebTestClient.ResponseSpec valueEquals(String headerName, String ... values) {
        return this.assertHeader(headerName, Arrays.asList(values), this.getHeaders().getOrEmpty((Object)headerName));
    }

    public WebTestClient.ResponseSpec valueEquals(String headerName, long value) {
        String actual = this.getHeaders().getFirst(headerName);
        this.exchangeResult.assertWithDiagnostics(() -> AssertionErrors.assertTrue("Response does not contain header '" + headerName + "'", actual != null));
        return this.assertHeader(headerName, value, Long.parseLong(Objects.requireNonNull(actual)));
    }

    public WebTestClient.ResponseSpec valueEqualsDate(String headerName, long value) {
        this.exchangeResult.assertWithDiagnostics(() -> {
            String headerValue = this.getHeaders().getFirst(headerName);
            AssertionErrors.assertNotNull("Response does not contain header '" + headerName + "'", headerValue);
            HttpHeaders headers = new HttpHeaders();
            headers.setDate("expected", value);
            headers.set("actual", headerValue);
            AssertionErrors.assertEquals("Response header '" + headerName + "'='" + headerValue + "' does not match expected value '" + headers.getFirst("expected") + "'", headers.getFirstDate("expected"), headers.getFirstDate("actual"));
        });
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec valueMatches(String name, String pattern) {
        String value = this.getRequiredValue(name);
        String message = this.getMessage(name) + "=[" + value + "] does not match [" + pattern + "]";
        this.exchangeResult.assertWithDiagnostics(() -> AssertionErrors.assertTrue(message, value.matches(pattern)));
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec valuesMatch(String name, String ... patterns) {
        this.exchangeResult.assertWithDiagnostics(() -> {
            List<String> values = this.getRequiredValues(name);
            AssertionErrors.assertTrue(this.getMessage(name) + " has fewer or more values " + values + " than number of patterns to match with " + Arrays.toString(patterns), values.size() == patterns.length);
            for (int i2 = 0; i2 < values.size(); ++i2) {
                String value = values.get(i2);
                String pattern = patterns[i2];
                AssertionErrors.assertTrue(this.getMessage(name) + "[" + i2 + "]='" + value + "' does not match '" + pattern + "'", value.matches(pattern));
            }
        });
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec value(String name, Matcher<? super String> matcher) {
        String value = this.getHeaders().getFirst(name);
        this.exchangeResult.assertWithDiagnostics(() -> {
            String message = this.getMessage(name);
            MatcherAssert.assertThat(message, value, matcher);
        });
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec values(String name, Matcher<? super Iterable<String>> matcher) {
        List values = this.getHeaders().get((Object)name);
        this.exchangeResult.assertWithDiagnostics(() -> {
            String message = this.getMessage(name);
            MatcherAssert.assertThat(message, values, matcher);
        });
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec value(String name, Consumer<String> consumer) {
        String value = this.getRequiredValue(name);
        this.exchangeResult.assertWithDiagnostics(() -> consumer.accept(value));
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec values(String name, Consumer<List<String>> consumer) {
        List<String> values = this.getRequiredValues(name);
        this.exchangeResult.assertWithDiagnostics(() -> consumer.accept(values));
        return this.responseSpec;
    }

    private String getRequiredValue(String name) {
        return this.getRequiredValues(name).get(0);
    }

    private List<String> getRequiredValues(String name) {
        List values = this.getHeaders().get((Object)name);
        if (CollectionUtils.isEmpty(values)) {
            this.exchangeResult.assertWithDiagnostics(() -> AssertionErrors.fail(this.getMessage(name) + " not found"));
        }
        return Objects.requireNonNull(values);
    }

    public WebTestClient.ResponseSpec exists(String name) {
        if (!this.getHeaders().containsKey((Object)name)) {
            String message = this.getMessage(name) + " does not exist";
            this.exchangeResult.assertWithDiagnostics(() -> AssertionErrors.fail(message));
        }
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec doesNotExist(String name) {
        if (this.getHeaders().containsKey((Object)name)) {
            String message = this.getMessage(name) + " exists with value=[" + this.getHeaders().getFirst(name) + "]";
            this.exchangeResult.assertWithDiagnostics(() -> AssertionErrors.fail(message));
        }
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec cacheControl(CacheControl cacheControl) {
        return this.assertHeader("Cache-Control", cacheControl.getHeaderValue(), this.getHeaders().getCacheControl());
    }

    public WebTestClient.ResponseSpec contentDisposition(ContentDisposition contentDisposition) {
        return this.assertHeader("Content-Disposition", contentDisposition, this.getHeaders().getContentDisposition());
    }

    public WebTestClient.ResponseSpec contentLength(long contentLength) {
        return this.assertHeader("Content-Length", contentLength, this.getHeaders().getContentLength());
    }

    public WebTestClient.ResponseSpec contentType(MediaType mediaType) {
        return this.assertHeader("Content-Type", mediaType, this.getHeaders().getContentType());
    }

    public WebTestClient.ResponseSpec contentType(String mediaType) {
        return this.contentType(MediaType.parseMediaType((String)mediaType));
    }

    public WebTestClient.ResponseSpec contentTypeCompatibleWith(MediaType mediaType) {
        MediaType actual = this.getHeaders().getContentType();
        String message = this.getMessage("Content-Type") + "=[" + actual + "] is not compatible with [" + mediaType + "]";
        this.exchangeResult.assertWithDiagnostics(() -> AssertionErrors.assertTrue(message, actual != null && actual.isCompatibleWith(mediaType)));
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec contentTypeCompatibleWith(String mediaType) {
        return this.contentTypeCompatibleWith(MediaType.parseMediaType((String)mediaType));
    }

    public WebTestClient.ResponseSpec expires(long expires) {
        return this.assertHeader("Expires", expires, this.getHeaders().getExpires());
    }

    public WebTestClient.ResponseSpec lastModified(long lastModified) {
        return this.assertHeader("Last-Modified", lastModified, this.getHeaders().getLastModified());
    }

    public WebTestClient.ResponseSpec location(String location) {
        return this.assertHeader("Location", URI.create(location), this.getHeaders().getLocation());
    }

    private HttpHeaders getHeaders() {
        return this.exchangeResult.getResponseHeaders();
    }

    private String getMessage(String headerName) {
        return "Response header '" + headerName + "'";
    }

    private WebTestClient.ResponseSpec assertHeader(String name, @Nullable Object expected, @Nullable Object actual) {
        this.exchangeResult.assertWithDiagnostics(() -> {
            String message = this.getMessage(name);
            AssertionErrors.assertEquals(message, expected, actual);
        });
        return this.responseSpec;
    }
}

