/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.HttpComponentsClientHttpConnector;
import org.springframework.http.client.reactive.JdkClientHttpConnector;
import org.springframework.http.client.reactive.JettyClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.http.client.reactive.ReactorNetty2ClientHttpConnector;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.lang.Nullable;
import org.springframework.test.web.reactive.server.DefaultWebTestClient;
import org.springframework.test.web.reactive.server.EntityExchangeResult;
import org.springframework.test.web.reactive.server.HttpHandlerConnector;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.test.web.reactive.server.WebTestClientConfigurer;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.ExchangeFunctions;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.server.adapter.WebHttpHandlerBuilder;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilderFactory;

class DefaultWebTestClientBuilder
implements WebTestClient.Builder {
    private static final boolean reactorNettyClientPresent;
    private static final boolean reactorNetty2ClientPresent;
    private static final boolean jettyClientPresent;
    private static final boolean httpComponentsClientPresent;
    private static final boolean webFluxPresent;
    @Nullable
    private final WebHttpHandlerBuilder httpHandlerBuilder;
    @Nullable
    private ClientHttpConnector connector;
    @Nullable
    private String baseUrl;
    @Nullable
    private UriBuilderFactory uriBuilderFactory;
    @Nullable
    private HttpHeaders defaultHeaders;
    @Nullable
    private MultiValueMap<String, String> defaultCookies;
    @Nullable
    private List<ExchangeFilterFunction> filters;
    private Consumer<EntityExchangeResult<?>> entityResultConsumer;
    @Nullable
    private ExchangeStrategies strategies;
    @Nullable
    private List<Consumer<ExchangeStrategies.Builder>> strategiesConfigurers;
    @Nullable
    private Duration responseTimeout;

    DefaultWebTestClientBuilder() {
        this(null, null);
    }

    DefaultWebTestClientBuilder(WebHttpHandlerBuilder httpHandlerBuilder) {
        this(httpHandlerBuilder, null);
    }

    DefaultWebTestClientBuilder(ClientHttpConnector connector) {
        this(null, connector);
    }

    DefaultWebTestClientBuilder(@Nullable WebHttpHandlerBuilder httpHandlerBuilder, @Nullable ClientHttpConnector connector) {
        this.entityResultConsumer = result -> {};
        Assert.isTrue(httpHandlerBuilder == null || connector == null, "Expected WebHttpHandlerBuilder or ClientHttpConnector but not both.");
        Assert.state(webFluxPresent, "To use WebTestClient, please add spring-webflux to the test classpath.");
        this.connector = connector;
        this.httpHandlerBuilder = httpHandlerBuilder != null ? httpHandlerBuilder.clone() : null;
    }

    DefaultWebTestClientBuilder(DefaultWebTestClientBuilder other) {
        this.entityResultConsumer = result -> {};
        this.httpHandlerBuilder = other.httpHandlerBuilder != null ? other.httpHandlerBuilder.clone() : null;
        this.connector = other.connector;
        this.responseTimeout = other.responseTimeout;
        this.baseUrl = other.baseUrl;
        this.uriBuilderFactory = other.uriBuilderFactory;
        if (other.defaultHeaders != null) {
            this.defaultHeaders = new HttpHeaders();
            this.defaultHeaders.putAll((Map)other.defaultHeaders);
        } else {
            this.defaultHeaders = null;
        }
        this.defaultCookies = other.defaultCookies != null ? new LinkedMultiValueMap(other.defaultCookies) : null;
        this.filters = other.filters != null ? new ArrayList<ExchangeFilterFunction>(other.filters) : null;
        this.entityResultConsumer = other.entityResultConsumer;
        this.strategies = other.strategies;
        this.strategiesConfigurers = other.strategiesConfigurers != null ? new ArrayList<Consumer<ExchangeStrategies.Builder>>(other.strategiesConfigurers) : null;
    }

    @Override
    public WebTestClient.Builder baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    @Override
    public WebTestClient.Builder uriBuilderFactory(UriBuilderFactory uriBuilderFactory) {
        this.uriBuilderFactory = uriBuilderFactory;
        return this;
    }

    @Override
    public WebTestClient.Builder defaultHeader(String header, String ... values) {
        this.initHeaders().put(header, Arrays.asList(values));
        return this;
    }

    @Override
    public WebTestClient.Builder defaultHeaders(Consumer<HttpHeaders> headersConsumer) {
        headersConsumer.accept(this.initHeaders());
        return this;
    }

    private HttpHeaders initHeaders() {
        if (this.defaultHeaders == null) {
            this.defaultHeaders = new HttpHeaders();
        }
        return this.defaultHeaders;
    }

    @Override
    public WebTestClient.Builder defaultCookie(String cookie, String ... values) {
        this.initCookies().addAll(cookie, Arrays.asList(values));
        return this;
    }

    @Override
    public WebTestClient.Builder defaultCookies(Consumer<MultiValueMap<String, String>> cookiesConsumer) {
        cookiesConsumer.accept(this.initCookies());
        return this;
    }

    private MultiValueMap<String, String> initCookies() {
        if (this.defaultCookies == null) {
            this.defaultCookies = new LinkedMultiValueMap<String, String>(3);
        }
        return this.defaultCookies;
    }

    @Override
    public WebTestClient.Builder filter(ExchangeFilterFunction filter) {
        Assert.notNull((Object)filter, "ExchangeFilterFunction is required");
        this.initFilters().add(filter);
        return this;
    }

    @Override
    public WebTestClient.Builder filters(Consumer<List<ExchangeFilterFunction>> filtersConsumer) {
        filtersConsumer.accept(this.initFilters());
        return this;
    }

    private List<ExchangeFilterFunction> initFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList<ExchangeFilterFunction>();
        }
        return this.filters;
    }

    @Override
    public WebTestClient.Builder entityExchangeResultConsumer(Consumer<EntityExchangeResult<?>> entityResultConsumer) {
        Assert.notNull(entityResultConsumer, "'entityResultConsumer' is required");
        this.entityResultConsumer = this.entityResultConsumer.andThen(entityResultConsumer);
        return this;
    }

    @Override
    public WebTestClient.Builder codecs(Consumer<ClientCodecConfigurer> configurer) {
        if (this.strategiesConfigurers == null) {
            this.strategiesConfigurers = new ArrayList<Consumer<ExchangeStrategies.Builder>>(4);
        }
        this.strategiesConfigurers.add(builder -> builder.codecs(configurer));
        return this;
    }

    @Override
    public WebTestClient.Builder exchangeStrategies(ExchangeStrategies strategies) {
        this.strategies = strategies;
        return this;
    }

    @Override
    @Deprecated
    public WebTestClient.Builder exchangeStrategies(Consumer<ExchangeStrategies.Builder> configurer) {
        if (this.strategiesConfigurers == null) {
            this.strategiesConfigurers = new ArrayList<Consumer<ExchangeStrategies.Builder>>(4);
        }
        this.strategiesConfigurers.add(configurer);
        return this;
    }

    @Override
    public WebTestClient.Builder apply(WebTestClientConfigurer configurer) {
        configurer.afterConfigurerAdded(this, this.httpHandlerBuilder, this.connector);
        return this;
    }

    @Override
    public WebTestClient.Builder responseTimeout(Duration timeout) {
        this.responseTimeout = timeout;
        return this;
    }

    @Override
    public WebTestClient.Builder clientConnector(ClientHttpConnector connector) {
        this.connector = connector;
        return this;
    }

    @Override
    public WebTestClient build() {
        ClientHttpConnector connectorToUse = this.connector;
        if (connectorToUse == null && this.httpHandlerBuilder != null) {
            connectorToUse = new HttpHandlerConnector(this.httpHandlerBuilder.build());
        }
        if (connectorToUse == null) {
            connectorToUse = DefaultWebTestClientBuilder.initConnector();
        }
        Function<ClientHttpConnector, ExchangeFunction> exchangeFactory = connector -> {
            ExchangeFunction exchange2 = ExchangeFunctions.create((ClientHttpConnector)connector, (ExchangeStrategies)this.initExchangeStrategies());
            if (CollectionUtils.isEmpty(this.filters)) {
                return exchange2;
            }
            return this.filters.stream().reduce(ExchangeFilterFunction::andThen).map(filter -> filter.apply(exchange2)).orElse(exchange2);
        };
        return new DefaultWebTestClient(connectorToUse, exchangeFactory, this.initUriBuilderFactory(), this.defaultHeaders != null ? HttpHeaders.readOnlyHttpHeaders((HttpHeaders)this.defaultHeaders) : null, this.defaultCookies != null ? CollectionUtils.unmodifiableMultiValueMap(this.defaultCookies) : null, this.entityResultConsumer, this.responseTimeout, new DefaultWebTestClientBuilder(this));
    }

    private static ClientHttpConnector initConnector() {
        if (reactorNettyClientPresent) {
            return new ReactorClientHttpConnector();
        }
        if (reactorNetty2ClientPresent) {
            return new ReactorNetty2ClientHttpConnector();
        }
        if (jettyClientPresent) {
            return new JettyClientHttpConnector();
        }
        if (httpComponentsClientPresent) {
            return new HttpComponentsClientHttpConnector();
        }
        return new JdkClientHttpConnector();
    }

    private ExchangeStrategies initExchangeStrategies() {
        if (CollectionUtils.isEmpty(this.strategiesConfigurers)) {
            return this.strategies != null ? this.strategies : ExchangeStrategies.withDefaults();
        }
        ExchangeStrategies.Builder builder = this.strategies != null ? this.strategies.mutate() : ExchangeStrategies.builder();
        this.strategiesConfigurers.forEach(configurer -> configurer.accept(builder));
        return builder.build();
    }

    private UriBuilderFactory initUriBuilderFactory() {
        if (this.uriBuilderFactory != null) {
            return this.uriBuilderFactory;
        }
        return this.baseUrl != null ? new DefaultUriBuilderFactory(this.baseUrl) : new DefaultUriBuilderFactory();
    }

    static {
        ClassLoader loader = DefaultWebTestClientBuilder.class.getClassLoader();
        reactorNettyClientPresent = ClassUtils.isPresent("reactor.netty.http.client.HttpClient", loader);
        reactorNetty2ClientPresent = ClassUtils.isPresent("reactor.netty5.http.client.HttpClient", loader);
        jettyClientPresent = ClassUtils.isPresent("wiremock.org.eclipse.jetty.client.HttpClient", loader);
        httpComponentsClientPresent = ClassUtils.isPresent("wiremock.org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient", loader) && ClassUtils.isPresent("wiremock.org.apache.hc.core5.reactive.ReactiveDataConsumer", loader);
        webFluxPresent = ClassUtils.isPresent("org.springframework.web.reactive.function.client.ExchangeFunction", loader);
    }
}

