/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.hint;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeHint;
import org.springframework.aot.hint.TypeReference;
import org.springframework.lang.Nullable;
import org.springframework.test.context.cache.DefaultCacheAwareContextLoaderDelegate;
import org.springframework.test.context.support.DefaultBootstrapContext;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.util.ClassUtils;

class TestContextRuntimeHints
implements RuntimeHintsRegistrar {
    TestContextRuntimeHints() {
    }

    @Override
    public void registerHints(RuntimeHints runtimeHints, @Nullable ClassLoader classLoader) {
        boolean servletPresent = ClassUtils.isPresent("wiremock.jakarta.servlet.Servlet", classLoader);
        boolean groovyPresent = ClassUtils.isPresent("groovy.lang.Closure", classLoader);
        ReflectionHints reflectionHints = runtimeHints.reflection();
        TestContextRuntimeHints.registerPublicConstructors(reflectionHints, DefaultCacheAwareContextLoaderDelegate.class, DefaultBootstrapContext.class);
        if (groovyPresent) {
            TestContextRuntimeHints.registerDeclaredConstructors(reflectionHints, "org.springframework.test.context.support.GenericGroovyXmlContextLoader");
            if (servletPresent) {
                TestContextRuntimeHints.registerDeclaredConstructors(reflectionHints, "org.springframework.test.context.web.GenericGroovyXmlWebContextLoader");
            }
        }
        TestContextRuntimeHints.registerAnnotation(reflectionHints, WebAppConfiguration.class);
    }

    private static void registerPublicConstructors(ReflectionHints reflectionHints, Class<?> ... types) {
        reflectionHints.registerTypes(TypeReference.listOf(types), TypeHint.builtWith(MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS));
    }

    private static void registerDeclaredConstructors(ReflectionHints reflectionHints, String ... classNames) {
        reflectionHints.registerTypes(TestContextRuntimeHints.listOf(classNames), TypeHint.builtWith(MemberCategory.INVOKE_DECLARED_CONSTRUCTORS));
    }

    private static List<TypeReference> listOf(String ... classNames) {
        return Arrays.stream(classNames).map(TypeReference::of).toList();
    }

    private static void registerAnnotation(ReflectionHints reflectionHints, Class<? extends Annotation> annotationType) {
        reflectionHints.registerType(annotationType, MemberCategory.INVOKE_DECLARED_METHODS);
    }
}

