/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.springframework.boot.test.mock.mockito.MockReset;
import org.springframework.boot.test.mock.mockito.QualifierDefinition;
import org.springframework.util.ObjectUtils;

abstract class Definition {
    private static final int MULTIPLIER = 31;
    private final String name;
    private final MockReset reset;
    private final boolean proxyTargetAware;
    private final QualifierDefinition qualifier;

    Definition(String name, MockReset reset, boolean proxyTargetAware, QualifierDefinition qualifier) {
        this.name = name;
        this.reset = reset != null ? reset : MockReset.AFTER;
        this.proxyTargetAware = proxyTargetAware;
        this.qualifier = qualifier;
    }

    String getName() {
        return this.name;
    }

    MockReset getReset() {
        return this.reset;
    }

    boolean isProxyTargetAware() {
        return this.proxyTargetAware;
    }

    QualifierDefinition getQualifier() {
        return this.qualifier;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        Definition other = (Definition)obj;
        boolean result = true;
        result = result && ObjectUtils.nullSafeEquals(this.name, other.name);
        result = result && ObjectUtils.nullSafeEquals((Object)this.reset, (Object)other.reset);
        result = result && ObjectUtils.nullSafeEquals(this.proxyTargetAware, other.proxyTargetAware);
        result = result && ObjectUtils.nullSafeEquals(this.qualifier, other.qualifier);
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.name);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.reset);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.proxyTargetAware);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.qualifier);
        return result;
    }
}

