/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import jakarta.json.bind.Jsonb;
import java.io.IOException;
import java.io.Reader;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.test.json.AbstractJsonMarshalTester;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;

public class JsonbTester<T>
extends AbstractJsonMarshalTester<T> {
    private final Jsonb jsonb;

    protected JsonbTester(Jsonb jsonb) {
        Assert.notNull((Object)jsonb, "Jsonb must not be null");
        this.jsonb = jsonb;
    }

    public JsonbTester(Class<?> resourceLoadClass, ResolvableType type, Jsonb jsonb) {
        super(resourceLoadClass, type);
        Assert.notNull((Object)jsonb, "Jsonb must not be null");
        this.jsonb = jsonb;
    }

    @Override
    protected String writeObject(T value, ResolvableType type) throws IOException {
        return this.jsonb.toJson(value, type.getType());
    }

    @Override
    protected T readObject(Reader reader, ResolvableType type) throws IOException {
        return (T)this.jsonb.fromJson(reader, type.getType());
    }

    public static void initFields(Object testInstance, Jsonb jsonb) {
        new JsonbFieldInitializer().initFields(testInstance, jsonb);
    }

    public static void initFields(Object testInstance, ObjectFactory<Jsonb> jsonb) {
        new JsonbFieldInitializer().initFields(testInstance, jsonb);
    }

    private static class JsonbFieldInitializer
    extends AbstractJsonMarshalTester.FieldInitializer<Jsonb> {
        protected JsonbFieldInitializer() {
            super(JsonbTester.class);
        }

        @Override
        protected AbstractJsonMarshalTester<Object> createTester(Class<?> resourceLoadClass, ResolvableType type, Jsonb marshaller) {
            return new JsonbTester<Object>(resourceLoadClass, type, marshaller);
        }
    }
}

