/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.log4j2;

import wiremock.org.apache.logging.log4j.core.LogEvent;
import wiremock.org.apache.logging.log4j.core.config.Configuration;
import wiremock.org.apache.logging.log4j.core.config.plugins.Plugin;
import wiremock.org.apache.logging.log4j.core.pattern.ConverterKeys;
import wiremock.org.apache.logging.log4j.core.pattern.ExtendedThrowablePatternConverter;
import wiremock.org.apache.logging.log4j.core.pattern.ThrowablePatternConverter;

@Plugin(name="ExtendedWhitespaceThrowablePatternConverter", category="Converter")
@ConverterKeys(value={"xwEx", "xwThrowable", "xwException"})
public final class ExtendedWhitespaceThrowablePatternConverter
extends ThrowablePatternConverter {
    private final ExtendedThrowablePatternConverter delegate;

    private ExtendedWhitespaceThrowablePatternConverter(Configuration configuration, String[] options2) {
        super("WhitespaceExtendedThrowable", "throwable", options2, configuration);
        this.delegate = ExtendedThrowablePatternConverter.newInstance((Configuration)configuration, (String[])options2);
    }

    public void format(LogEvent event, StringBuilder buffer) {
        if (event.getThrown() != null) {
            buffer.append(this.options.getSeparator());
            this.delegate.format(event, buffer);
            buffer.append(this.options.getSeparator());
        }
    }

    public static ExtendedWhitespaceThrowablePatternConverter newInstance(Configuration configuration, String[] options2) {
        return new ExtendedWhitespaceThrowablePatternConverter(configuration, options2);
    }
}

