/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.log4j2;

import org.springframework.boot.logging.CorrelationIdFormatter;
import org.springframework.util.ObjectUtils;
import wiremock.org.apache.logging.log4j.core.LogEvent;
import wiremock.org.apache.logging.log4j.core.config.plugins.Plugin;
import wiremock.org.apache.logging.log4j.core.pattern.ConverterKeys;
import wiremock.org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import wiremock.org.apache.logging.log4j.util.PerformanceSensitive;
import wiremock.org.apache.logging.log4j.util.ReadOnlyStringMap;

@Plugin(name="CorrelationIdConverter", category="Converter")
@ConverterKeys(value={"correlationId"})
@PerformanceSensitive(value={"allocation"})
public final class CorrelationIdConverter
extends LogEventPatternConverter {
    private final CorrelationIdFormatter formatter;

    private CorrelationIdConverter(CorrelationIdFormatter formatter) {
        super("correlationId{%s}".formatted(formatter), "mdc");
        this.formatter = formatter;
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        ReadOnlyStringMap contextData = event.getContextData();
        this.formatter.formatTo(arg_0 -> ((ReadOnlyStringMap)contextData).getValue(arg_0), toAppendTo);
    }

    public static CorrelationIdConverter newInstance(String[] options2) {
        String pattern = !ObjectUtils.isEmpty(options2) ? options2[0] : null;
        return new CorrelationIdConverter(CorrelationIdFormatter.of(pattern));
    }
}

