/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.NumberUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import wiremock.org.apache.commons.logging.Log;
import wiremock.org.apache.commons.logging.LogFactory;

class TypeConverterDelegate {
    private static final Log logger = LogFactory.getLog(TypeConverterDelegate.class);
    private final PropertyEditorRegistrySupport propertyEditorRegistry;
    @Nullable
    private final Object targetObject;

    public TypeConverterDelegate(PropertyEditorRegistrySupport propertyEditorRegistry) {
        this(propertyEditorRegistry, null);
    }

    public TypeConverterDelegate(PropertyEditorRegistrySupport propertyEditorRegistry, @Nullable Object targetObject) {
        this.propertyEditorRegistry = propertyEditorRegistry;
        this.targetObject = targetObject;
    }

    @Nullable
    public <T> T convertIfNecessary(@Nullable String propertyName, @Nullable Object oldValue, Object newValue, @Nullable Class<T> requiredType) throws IllegalArgumentException {
        return this.convertIfNecessary(propertyName, oldValue, newValue, requiredType, TypeDescriptor.valueOf(requiredType));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public <T> T convertIfNecessary(@Nullable String propertyName, @Nullable Object oldValue, @Nullable Object newValue, @Nullable Class<T> requiredType, @Nullable TypeDescriptor typeDescriptor) throws IllegalArgumentException {
        void var9_26;
        boolean standardConversion;
        ConversionFailedException conversionAttemptEx;
        PropertyEditor editor;
        block37: {
            ConversionService conversionService;
            block42: {
                block38: {
                    void var9_21;
                    block41: {
                        String text;
                        block36: {
                            block40: {
                                void var9_14;
                                block39: {
                                    TypeDescriptor typeDescriptor2;
                                    editor = this.propertyEditorRegistry.findCustomEditor(requiredType, propertyName);
                                    conversionAttemptEx = null;
                                    conversionService = this.propertyEditorRegistry.getConversionService();
                                    if (editor == null && conversionService != null && newValue != null && typeDescriptor != null && conversionService.canConvert(typeDescriptor2 = TypeDescriptor.forObject(newValue), typeDescriptor)) {
                                        try {
                                            return (T)conversionService.convert(newValue, typeDescriptor2, typeDescriptor);
                                        }
                                        catch (ConversionFailedException ex) {
                                            conversionAttemptEx = ex;
                                        }
                                    }
                                    String[] stringArray = newValue;
                                    if (editor != null || requiredType != null && !ClassUtils.isAssignableValue(requiredType, stringArray)) {
                                        void var9_12;
                                        TypeDescriptor elementTypeDesc;
                                        if (typeDescriptor != null && requiredType != null && Collection.class.isAssignableFrom(requiredType) && (elementTypeDesc = typeDescriptor.getElementTypeDescriptor()) != null) {
                                            Class<?> elementType = elementTypeDesc.getType();
                                            if (stringArray instanceof String) {
                                                String text2 = (String)stringArray;
                                                if (Class.class == elementType || Enum.class.isAssignableFrom(elementType)) {
                                                    String[] stringArray2 = StringUtils.commaDelimitedListToStringArray(text2);
                                                }
                                                if (editor == null && String.class != elementType) {
                                                    editor = this.findDefaultEditor((Class<?>)elementType.arrayType());
                                                }
                                            }
                                        }
                                        if (editor == null) {
                                            editor = this.findDefaultEditor(requiredType);
                                        }
                                        Object object = this.doConvertValue(oldValue, var9_12, requiredType, editor);
                                    }
                                    standardConversion = false;
                                    if (requiredType == null) break block37;
                                    if (var9_14 == null) break block38;
                                    if (Object.class == requiredType) {
                                        return var9_14;
                                    }
                                    if (requiredType.isArray()) {
                                        void var9_16;
                                        if (var9_14 instanceof String) {
                                            String text3 = (String)var9_14;
                                            if (Enum.class.isAssignableFrom((Class<?>)requiredType.componentType())) {
                                                String[] stringArray3 = StringUtils.commaDelimitedListToStringArray(text3);
                                            }
                                        }
                                        return (T)this.convertToTypedArray(var9_16, propertyName, (Class<?>)requiredType.componentType());
                                    }
                                    if (!var9_14.getClass().isArray()) break block39;
                                    if (Collection.class.isAssignableFrom(requiredType)) {
                                        Collection<?> collection = this.convertToTypedCollection(CollectionUtils.arrayToList(var9_14), propertyName, requiredType, typeDescriptor);
                                        standardConversion = true;
                                        break block40;
                                    } else if (Array.getLength(var9_14) == 1) {
                                        Object object = Array.get(var9_14, 0);
                                        standardConversion = true;
                                    }
                                    break block40;
                                }
                                if (var9_14 instanceof Collection) {
                                    Collection coll = (Collection)var9_14;
                                    Collection<?> collection = this.convertToTypedCollection(coll, propertyName, requiredType, typeDescriptor);
                                    standardConversion = true;
                                } else if (var9_14 instanceof Map) {
                                    Map map = (Map)var9_14;
                                    Map<?, ?> map2 = this.convertToTypedMap(map, propertyName, requiredType, typeDescriptor);
                                    standardConversion = true;
                                }
                            }
                            if (String.class == requiredType && ClassUtils.isPrimitiveOrWrapper(var9_21.getClass())) {
                                return (T)var9_21.toString();
                            }
                            if (!(var9_21 instanceof String)) break block41;
                            text = (String)var9_21;
                            if (requiredType.isInstance(var9_21)) break block41;
                            if (conversionAttemptEx == null && !requiredType.isInterface() && !requiredType.isEnum()) {
                                try {
                                    Constructor<T> strCtor = requiredType.getConstructor(String.class);
                                    return BeanUtils.instantiateClass(strCtor, var9_21);
                                }
                                catch (NoSuchMethodException ex) {
                                    if (logger.isTraceEnabled()) {
                                        logger.trace("No String constructor found on type [" + requiredType.getName() + "]", ex);
                                    }
                                }
                                catch (Exception ex) {
                                    if (!logger.isDebugEnabled()) break block36;
                                    logger.debug("Construction via String failed for type [" + requiredType.getName() + "]", ex);
                                }
                            }
                        }
                        String trimmedValue = text.trim();
                        if (requiredType.isEnum() && trimmedValue.isEmpty()) {
                            return null;
                        }
                        Object object = this.attemptToConvertStringToEnum(requiredType, trimmedValue, var9_21);
                        standardConversion = true;
                        break block42;
                    }
                    if (var9_21 instanceof Number) {
                        Number num = (Number)var9_21;
                        if (Number.class.isAssignableFrom(requiredType)) {
                            T t2 = NumberUtils.convertNumberToTargetClass(num, requiredType);
                            standardConversion = true;
                        }
                    }
                    break block42;
                }
                if (requiredType == Optional.class) {
                    Optional optional = Optional.empty();
                }
            }
            if (!ClassUtils.isAssignableValue(requiredType, var9_26)) {
                TypeDescriptor sourceTypeDesc;
                if (conversionAttemptEx != null) {
                    throw conversionAttemptEx;
                }
                if (conversionService != null && typeDescriptor != null && conversionService.canConvert(sourceTypeDesc = TypeDescriptor.forObject(newValue), typeDescriptor)) {
                    return (T)conversionService.convert(newValue, sourceTypeDesc, typeDescriptor);
                }
                StringBuilder msg = new StringBuilder();
                msg.append("Cannot convert value of type '").append(ClassUtils.getDescriptiveType(newValue));
                msg.append("' to required type '").append(ClassUtils.getQualifiedName(requiredType)).append('\'');
                if (propertyName != null) {
                    msg.append(" for property '").append(propertyName).append('\'');
                }
                if (editor != null) {
                    msg.append(": PropertyEditor [").append(editor.getClass().getName()).append("] returned inappropriate value of type '").append(ClassUtils.getDescriptiveType(var9_26)).append('\'');
                    throw new IllegalArgumentException(msg.toString());
                }
                msg.append(": no matching editors or conversion strategy found");
                throw new IllegalStateException(msg.toString());
            }
        }
        if (conversionAttemptEx != null) {
            if (editor == null && !standardConversion && requiredType != null && Object.class != requiredType) {
                throw conversionAttemptEx;
            }
            logger.debug("Original ConversionService attempt failed - ignored since PropertyEditor based conversion eventually succeeded", conversionAttemptEx);
        }
        return var9_26;
    }

    private Object attemptToConvertStringToEnum(Class<?> requiredType, String trimmedValue, Object currentConvertedValue) {
        Object convertedValue;
        block9: {
            block8: {
                int index;
                convertedValue = currentConvertedValue;
                if (Enum.class == requiredType && this.targetObject != null && (index = trimmedValue.lastIndexOf(46)) > -1) {
                    String enumType = trimmedValue.substring(0, index);
                    String fieldName = trimmedValue.substring(index + 1);
                    ClassLoader cl = this.targetObject.getClass().getClassLoader();
                    try {
                        Class<?> enumValueType = ClassUtils.forName(enumType, cl);
                        Field enumField = enumValueType.getField(fieldName);
                        convertedValue = enumField.get(null);
                    }
                    catch (ClassNotFoundException ex) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Enum class [" + enumType + "] cannot be loaded", ex);
                        }
                    }
                    catch (Throwable ex) {
                        if (!logger.isTraceEnabled()) break block8;
                        logger.trace("Field [" + fieldName + "] isn't an enum value for type [" + enumType + "]", ex);
                    }
                }
            }
            if (convertedValue == currentConvertedValue) {
                try {
                    Field enumField = requiredType.getField(trimmedValue);
                    ReflectionUtils.makeAccessible(enumField);
                    convertedValue = enumField.get(null);
                }
                catch (Throwable ex) {
                    if (!logger.isTraceEnabled()) break block9;
                    logger.trace("Field [" + convertedValue + "] isn't an enum value", ex);
                }
            }
        }
        return convertedValue;
    }

    @Nullable
    private PropertyEditor findDefaultEditor(@Nullable Class<?> requiredType) {
        PropertyEditor editor = null;
        if (requiredType != null && (editor = this.propertyEditorRegistry.getDefaultEditor(requiredType)) == null && String.class != requiredType) {
            editor = BeanUtils.findEditorByConvention(requiredType);
        }
        return editor;
    }

    @Nullable
    private Object doConvertValue(@Nullable Object oldValue, @Nullable Object newValue, @Nullable Class<?> requiredType, @Nullable PropertyEditor editor) {
        Object convertedValue;
        block10: {
            convertedValue = newValue;
            if (editor != null && !(convertedValue instanceof String)) {
                try {
                    editor.setValue(convertedValue);
                    Object newConvertedValue = editor.getValue();
                    if (newConvertedValue != convertedValue) {
                        convertedValue = newConvertedValue;
                        editor = null;
                    }
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block10;
                    logger.debug("PropertyEditor [" + editor.getClass().getName() + "] does not support setValue call", ex);
                }
            }
        }
        Object returnValue = convertedValue;
        if (requiredType != null && !requiredType.isArray() && convertedValue instanceof String[]) {
            Object[] array = (String[])convertedValue;
            if (logger.isTraceEnabled()) {
                logger.trace("Converting String array to comma-delimited String [" + convertedValue + "]");
            }
            convertedValue = StringUtils.arrayToCommaDelimitedString(array);
        }
        if (convertedValue instanceof String) {
            String newTextValue = (String)convertedValue;
            if (editor != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Converting String to [" + requiredType + "] using property editor [" + editor + "]");
                }
                return this.doConvertTextValue(oldValue, newTextValue, editor);
            }
            if (String.class == requiredType) {
                returnValue = convertedValue;
            }
        }
        return returnValue;
    }

    private Object doConvertTextValue(@Nullable Object oldValue, String newTextValue, PropertyEditor editor) {
        block2: {
            try {
                editor.setValue(oldValue);
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("PropertyEditor [" + editor.getClass().getName() + "] does not support setValue call", ex);
            }
        }
        editor.setAsText(newTextValue);
        return editor.getValue();
    }

    private Object convertToTypedArray(Object input, @Nullable String propertyName, Class<?> componentType) {
        if (input instanceof Collection) {
            Collection coll = (Collection)input;
            Object result = Array.newInstance(componentType, coll.size());
            int i2 = 0;
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                Object value = this.convertIfNecessary(this.buildIndexedPropertyName(propertyName, i2), null, it.next(), componentType);
                Array.set(result, i2, value);
                ++i2;
            }
            return result;
        }
        if (input.getClass().isArray()) {
            if (componentType.equals(input.getClass().componentType()) && !this.propertyEditorRegistry.hasCustomEditorForElement(componentType, propertyName)) {
                return input;
            }
            int arrayLength = Array.getLength(input);
            Object result = Array.newInstance(componentType, arrayLength);
            for (int i3 = 0; i3 < arrayLength; ++i3) {
                Object value = this.convertIfNecessary(this.buildIndexedPropertyName(propertyName, i3), null, Array.get(input, i3), componentType);
                Array.set(result, i3, value);
            }
            return result;
        }
        Object result = Array.newInstance(componentType, 1);
        Object value = this.convertIfNecessary(this.buildIndexedPropertyName(propertyName, 0), null, input, componentType);
        Array.set(result, 0, value);
        return result;
    }

    private Collection<?> convertToTypedCollection(Collection<?> original, @Nullable String propertyName, Class<?> requiredType, @Nullable TypeDescriptor typeDescriptor) {
        Collection<Object> convertedCopy;
        Iterator<?> it;
        TypeDescriptor elementType;
        if (!Collection.class.isAssignableFrom(requiredType)) {
            return original;
        }
        boolean approximable = CollectionFactory.isApproximableCollectionType(requiredType);
        if (!approximable && !this.canCreateCopy(requiredType)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Custom Collection type [" + original.getClass().getName() + "] does not allow for creating a copy - injecting original Collection as-is");
            }
            return original;
        }
        boolean originalAllowed = requiredType.isInstance(original);
        TypeDescriptor typeDescriptor2 = elementType = typeDescriptor != null ? typeDescriptor.getElementTypeDescriptor() : null;
        if (elementType == null && originalAllowed && !this.propertyEditorRegistry.hasCustomEditorForElement(null, propertyName)) {
            return original;
        }
        try {
            it = original.iterator();
        }
        catch (Throwable ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cannot access Collection of type [" + original.getClass().getName() + "] - injecting original Collection as-is: " + ex);
            }
            return original;
        }
        try {
            convertedCopy = approximable && requiredType.isInstance(original) ? CollectionFactory.createApproximateCollection(original, original.size()) : CollectionFactory.createCollection(requiredType, original.size());
        }
        catch (Throwable ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cannot create copy of Collection type [" + original.getClass().getName() + "] - injecting original Collection as-is: " + ex);
            }
            return original;
        }
        int i2 = 0;
        while (it.hasNext()) {
            Object element = it.next();
            String indexedPropertyName = this.buildIndexedPropertyName(propertyName, i2);
            Object convertedElement = this.convertIfNecessary(indexedPropertyName, null, element, elementType != null ? elementType.getType() : null, elementType);
            try {
                convertedCopy.add(convertedElement);
            }
            catch (Throwable ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Collection type [" + original.getClass().getName() + "] seems to be read-only - injecting original Collection as-is: " + ex);
                }
                return original;
            }
            originalAllowed = originalAllowed && element == convertedElement;
            ++i2;
        }
        return originalAllowed ? original : convertedCopy;
    }

    private Map<?, ?> convertToTypedMap(Map<?, ?> original, @Nullable String propertyName, Class<?> requiredType, @Nullable TypeDescriptor typeDescriptor) {
        Map<Object, Object> convertedCopy;
        Iterator<Map.Entry<?, ?>> it;
        TypeDescriptor valueType;
        if (!Map.class.isAssignableFrom(requiredType)) {
            return original;
        }
        boolean approximable = CollectionFactory.isApproximableMapType(requiredType);
        if (!approximable && !this.canCreateCopy(requiredType)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Custom Map type [" + original.getClass().getName() + "] does not allow for creating a copy - injecting original Map as-is");
            }
            return original;
        }
        boolean originalAllowed = requiredType.isInstance(original);
        TypeDescriptor keyType = typeDescriptor != null ? typeDescriptor.getMapKeyTypeDescriptor() : null;
        TypeDescriptor typeDescriptor2 = valueType = typeDescriptor != null ? typeDescriptor.getMapValueTypeDescriptor() : null;
        if (keyType == null && valueType == null && originalAllowed && !this.propertyEditorRegistry.hasCustomEditorForElement(null, propertyName)) {
            return original;
        }
        try {
            it = original.entrySet().iterator();
        }
        catch (Throwable ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cannot access Map of type [" + original.getClass().getName() + "] - injecting original Map as-is: " + ex);
            }
            return original;
        }
        try {
            convertedCopy = approximable && requiredType.isInstance(original) ? CollectionFactory.createApproximateMap(original, original.size()) : CollectionFactory.createMap(requiredType, original.size());
        }
        catch (Throwable ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cannot create copy of Map type [" + original.getClass().getName() + "] - injecting original Map as-is: " + ex);
            }
            return original;
        }
        while (it.hasNext()) {
            Map.Entry<?, ?> entry = it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            String keyedPropertyName = this.buildKeyedPropertyName(propertyName, key);
            Object convertedKey = this.convertIfNecessary(keyedPropertyName, null, key, keyType != null ? keyType.getType() : null, keyType);
            Object convertedValue = this.convertIfNecessary(keyedPropertyName, null, value, valueType != null ? valueType.getType() : null, valueType);
            try {
                convertedCopy.put(convertedKey, convertedValue);
            }
            catch (Throwable ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Map type [" + original.getClass().getName() + "] seems to be read-only - injecting original Map as-is: " + ex);
                }
                return original;
            }
            originalAllowed = originalAllowed && key == convertedKey && value == convertedValue;
        }
        return originalAllowed ? original : convertedCopy;
    }

    @Nullable
    private String buildIndexedPropertyName(@Nullable String propertyName, int index) {
        return propertyName != null ? propertyName + "[" + index + "]" : null;
    }

    @Nullable
    private String buildKeyedPropertyName(@Nullable String propertyName, Object key) {
        return propertyName != null ? propertyName + "[" + key + "]" : null;
    }

    private boolean canCreateCopy(Class<?> requiredType) {
        return !requiredType.isInterface() && !Modifier.isAbstract(requiredType.getModifiers()) && Modifier.isPublic(requiredType.getModifiers()) && ClassUtils.hasConstructor(requiredType, new Class[0]);
    }
}

