/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.github.tomakehurst.wiremock.matching.MemoizingMatchResult;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.stubbing.Scenario;
import com.github.tomakehurst.wiremock.stubbing.Scenarios;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.NearMiss;
import com.github.tomakehurst.wiremock.verification.RequestJournal;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class NearMissCalculator {
    public static final int NEAR_MISS_COUNT = 3;
    public static final Comparator<NearMiss> NEAR_MISS_ASCENDING_COMPARATOR = Comparable::compareTo;
    private final StubMappings stubMappings;
    private final RequestJournal requestJournal;
    private final Scenarios scenarios;
    private final Map<String, RequestMatcherExtension> customMatchers;

    public NearMissCalculator(StubMappings stubMappings, RequestJournal requestJournal, Scenarios scenarios) {
        this(stubMappings, requestJournal, scenarios, Map.of());
    }

    public NearMissCalculator(StubMappings stubMappings, RequestJournal requestJournal, Scenarios scenarios, Map<String, RequestMatcherExtension> customMatchers) {
        this.stubMappings = stubMappings;
        this.requestJournal = requestJournal;
        this.scenarios = scenarios;
        this.customMatchers = customMatchers;
    }

    public List<NearMiss> findNearestTo(LoggedRequest request2) {
        List<StubMapping> allMappings = this.stubMappings.getAll();
        return NearMissCalculator.sortAndTruncate(allMappings.stream().map(stubMapping -> {
            MemoizingMatchResult matchResult = new MemoizingMatchResult(stubMapping.getRequest().match(request2, this.customMatchers));
            String actualScenarioState = this.getScenarioStateOrNull((StubMapping)stubMapping);
            return new NearMiss(request2, (StubMapping)stubMapping, matchResult, actualScenarioState);
        }).collect(Collectors.toList()), allMappings.size());
    }

    private String getScenarioStateOrNull(StubMapping stubMapping) {
        if (!stubMapping.isInScenario()) {
            return null;
        }
        Scenario scenario = this.scenarios.getByName(stubMapping.getScenarioName());
        return scenario != null ? scenario.getState() : null;
    }

    public List<NearMiss> findNearestTo(RequestPattern requestPattern) {
        List<ServeEvent> serveEvents = this.requestJournal.getAllServeEvents();
        return NearMissCalculator.sortAndTruncate(serveEvents.stream().map(serveEvent -> {
            MemoizingMatchResult matchResult = new MemoizingMatchResult(requestPattern.match(serveEvent.getRequest(), this.customMatchers));
            return new NearMiss(serveEvent.getRequest(), requestPattern, matchResult);
        }).collect(Collectors.toList()), serveEvents.size());
    }

    private static List<NearMiss> sortAndTruncate(List<NearMiss> nearMisses, int originalSize) {
        nearMisses.sort(NEAR_MISS_ASCENDING_COMPARATOR);
        return nearMisses.subList(0, Math.min(3, originalSize));
    }
}

