/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import com.github.tomakehurst.wiremock.common.LocalNotifier;
import java.util.Arrays;

public class BodyChunker {
    public static byte[][] chunkBody(byte[] body2, int numberOfChunks) {
        int chunkStart;
        if (numberOfChunks < 1) {
            LocalNotifier.notifier().error("Number of chunks set to value less than 1: " + numberOfChunks);
            numberOfChunks = 1;
        }
        if (body2.length < numberOfChunks) {
            LocalNotifier.notifier().error("Number of chunks set to value greater then body length. Number of chunks: " + numberOfChunks + ". Body length: " + body2.length + ". Overriding number of chunks to body length.");
            numberOfChunks = body2.length;
        }
        int chunkSize = body2.length / numberOfChunks;
        int excessSize = body2.length % numberOfChunks;
        byte[][] chunkedBody = new byte[numberOfChunks][];
        for (int chunkIndex = 0; chunkIndex < numberOfChunks; ++chunkIndex) {
            chunkStart = chunkIndex * chunkSize;
            int chunkEnd = chunkStart + chunkSize;
            chunkedBody[chunkIndex] = Arrays.copyOfRange(body2, chunkStart, chunkEnd);
        }
        if (excessSize > 0) {
            int lastChunkIndex = numberOfChunks - 1;
            chunkStart = lastChunkIndex * chunkSize;
            int newChunkEnd = chunkStart + chunkSize + excessSize;
            chunkedBody[lastChunkIndex] = Arrays.copyOfRange(body2, chunkStart, newChunkEnd);
        }
        return chunkedBody;
    }
}

