/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.InputStreamSource;
import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.extension.ResponseTransformer;
import com.github.tomakehurst.wiremock.extension.ResponseTransformerV2;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.ProxyResponseRenderer;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;
import com.github.tomakehurst.wiremock.store.BlobStore;
import com.github.tomakehurst.wiremock.store.SettingsStore;
import com.github.tomakehurst.wiremock.store.files.BlobStoreFileSource;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.List;

public class StubResponseRenderer
implements ResponseRenderer {
    private final BlobStore filesBlobStore;
    private final FileSource filesFileSource;
    private final SettingsStore settingsStore;
    private final ProxyResponseRenderer proxyResponseRenderer;
    private final List<ResponseTransformer> responseTransformers;
    private final List<ResponseTransformerV2> v2ResponseTransformers;

    public StubResponseRenderer(BlobStore filesBlobStore, SettingsStore settingsStore, ProxyResponseRenderer proxyResponseRenderer, List<ResponseTransformer> responseTransformers, List<ResponseTransformerV2> v2ResponseTransformers) {
        this.filesBlobStore = filesBlobStore;
        this.settingsStore = settingsStore;
        this.proxyResponseRenderer = proxyResponseRenderer;
        this.responseTransformers = responseTransformers;
        this.v2ResponseTransformers = v2ResponseTransformers;
        this.filesFileSource = new BlobStoreFileSource(filesBlobStore);
    }

    @Override
    public Response render(ServeEvent serveEvent) {
        ResponseDefinition responseDefinition = serveEvent.getResponseDefinition();
        if (!responseDefinition.wasConfigured()) {
            return Response.notConfigured();
        }
        Response response = this.buildResponse(serveEvent);
        response = this.applyTransformations(responseDefinition.getOriginalRequest(), responseDefinition, response, this.responseTransformers);
        response = this.applyV2Transformations(response, serveEvent, this.v2ResponseTransformers);
        return response;
    }

    private Response buildResponse(ServeEvent serveEvent) {
        if (serveEvent.getResponseDefinition().isProxyResponse()) {
            return this.proxyResponseRenderer.render(serveEvent);
        }
        Response.Builder responseBuilder = this.renderDirectly(serveEvent);
        return responseBuilder.build();
    }

    private Response applyTransformations(Request request2, ResponseDefinition responseDefinition, Response response, List<ResponseTransformer> transformers) {
        if (transformers.isEmpty()) {
            return response;
        }
        ResponseTransformer transformer = transformers.get(0);
        Response newResponse = transformer.applyGlobally() || responseDefinition.hasTransformer(transformer) ? transformer.transform(request2, response, this.filesFileSource, responseDefinition.getTransformerParameters()) : response;
        return this.applyTransformations(request2, responseDefinition, newResponse, transformers.subList(1, transformers.size()));
    }

    private Response applyV2Transformations(Response response, ServeEvent serveEvent, List<ResponseTransformerV2> transformers) {
        if (transformers.isEmpty()) {
            return response;
        }
        ResponseTransformerV2 transformer = transformers.get(0);
        ResponseDefinition responseDefinition = serveEvent.getResponseDefinition();
        Response newResponse = transformer.applyGlobally() || responseDefinition.hasTransformer(transformer) ? transformer.transform(response, serveEvent) : response;
        return this.applyV2Transformations(newResponse, serveEvent, transformers.subList(1, transformers.size()));
    }

    private Response.Builder renderDirectly(ServeEvent serveEvent) {
        ResponseDefinition responseDefinition = serveEvent.getResponseDefinition();
        HttpHeaders headers = responseDefinition.getHeaders();
        StubMapping stubMapping = serveEvent.getStubMapping();
        if (serveEvent.getWasMatched() && stubMapping != null) {
            headers = ParameterUtils.getFirstNonNull(headers, new HttpHeaders()).plus(new HttpHeader("Matched-Stub-Id", stubMapping.getId().toString()));
            if (stubMapping.getName() != null) {
                headers = headers.plus(new HttpHeader("Matched-Stub-Name", stubMapping.getName()));
            }
        }
        GlobalSettings settings = this.settingsStore.get();
        Response.Builder responseBuilder = Response.response().status(responseDefinition.getStatus()).statusMessage(responseDefinition.getStatusMessage()).headers(headers).fault(responseDefinition.getFault()).configureDelay(settings.getFixedDelay(), settings.getDelayDistribution(), responseDefinition.getFixedDelayMilliseconds(), responseDefinition.getDelayDistribution()).chunkedDribbleDelay(responseDefinition.getChunkedDribbleDelay());
        if (responseDefinition.specifiesBodyFile()) {
            InputStreamSource bodyStreamSource = this.filesBlobStore.getStreamSource(responseDefinition.getBodyFileName());
            responseBuilder.body(bodyStreamSource);
        } else if (responseDefinition.specifiesBodyContent()) {
            responseBuilder.body(responseDefinition.getByteBody());
        }
        return responseBuilder;
    }
}

