/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import wiremock.com.github.jknack.handlebars.Options;

public class PickRandomHelper
extends HandlebarsHelper<Object> {
    @Override
    public Object apply(Object context, Options options2) throws IOException {
        if (context == null) {
            return this.handleError("Must specify either a single list argument or a set of single value arguments.");
        }
        ArrayList<Object> valueList = new ArrayList<Object>();
        if (Iterable.class.isAssignableFrom(context.getClass())) {
            ((Iterable)context).forEach(valueList::add);
        } else {
            valueList.add(context);
            valueList.addAll(Arrays.asList(options2.params));
        }
        Integer count = (Integer)options2.hash.get("count");
        if (count != null && count > 0) {
            int desiredLength = Math.min(valueList.size(), count);
            for (int i2 = 0; i2 < desiredLength; ++i2) {
                Collections.swap(valueList, i2, ThreadLocalRandom.current().nextInt(i2, valueList.size()));
            }
            return valueList.subList(0, desiredLength);
        }
        int index = ThreadLocalRandom.current().nextInt(valueList.size());
        return valueList.get(index);
    }
}

