/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class ParameterUtils {
    private ParameterUtils() {
    }

    public static <T> T getFirstNonNull(T first, T second) {
        if (first != null) {
            return first;
        }
        if (second != null) {
            return second;
        }
        throw new NullPointerException("Both parameters are null");
    }

    public static <T> T getFirstNonNull(T first, T second, String etr) {
        if (first != null) {
            return first;
        }
        if (second != null) {
            return second;
        }
        throw new NullPointerException(etr);
    }

    public static void checkParameter(boolean condition, String errorMessage) {
        if (!condition) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void checkState(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalStateException(errorMessage);
        }
    }

    public static <T> T checkNotNull(T value, String errorMessage) {
        if (value == null) {
            throw new NullPointerException(errorMessage);
        }
        return value;
    }

    public static <T> int indexOf(Iterable<T> iterable, Predicate<? super T> predicate) {
        ParameterUtils.checkNotNull(iterable, "iterable");
        ParameterUtils.checkNotNull(predicate, "predicate");
        Iterator<T> iterator = iterable.iterator();
        int i2 = 0;
        while (iterator.hasNext()) {
            T current = iterator.next();
            if (predicate.test(current)) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public static <T> T getFirst(Iterable<T> iterable, T defaultValue) {
        return iterable != null && iterable.iterator().hasNext() ? iterable.iterator().next() : defaultValue;
    }

    public static <T> T getLast(Iterable<T> iterable) {
        T current;
        if (iterable == null || !iterable.iterator().hasNext()) {
            throw new NoSuchElementException();
        }
        Iterator<T> iterator = iterable.iterator();
        do {
            current = iterator.next();
        } while (iterator.hasNext());
        return current;
    }
}

