/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.SubsystemInformation;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.SubsystemXmlWriterRegistry;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.as.model.test.ChildFirstClassLoaderBuilder;
import org.jboss.as.model.test.ModelFixer;
import org.jboss.as.model.test.ModelTestBootOperationsBuilder;
import org.jboss.as.model.test.ModelTestControllerVersion;
import org.jboss.as.model.test.ModelTestKernelServices;
import org.jboss.as.model.test.ModelTestModelControllerService;
import org.jboss.as.model.test.ModelTestOperationValidatorFilter;
import org.jboss.as.model.test.ModelTestParser;
import org.jboss.as.model.test.ModelTestUtils;
import org.jboss.as.model.test.OperationFixer;
import org.jboss.as.model.test.StringConfigurationPersister;
import org.jboss.as.subsystem.bridge.impl.LegacyControllerKernelServicesProxy;
import org.jboss.as.subsystem.bridge.local.ScopedKernelServicesBootstrap;
import org.jboss.as.subsystem.test.AbstractKernelServicesImpl;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.AdditionalParsers;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.as.subsystem.test.KernelServicesBuilder;
import org.jboss.as.subsystem.test.KernelServicesInternal;
import org.jboss.as.subsystem.test.LegacyKernelServicesInitializer;
import org.jboss.as.subsystem.test.ModelDescriptionValidator;
import org.jboss.as.subsystem.test.TestParser;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.filter.ClassFilter;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLMapper;
import org.junit.Assert;
import org.xnio.IoUtils;

final class SubsystemTestDelegate {
    private final String TEST_NAMESPACE = "urn.org.jboss.test:1.0";
    private static final ModelNode SUCCESS = new ModelNode();
    private final Class<?> testClass;
    private final List<KernelServices> kernelServices = new ArrayList<KernelServices>();
    protected final String mainSubsystemName;
    private final Extension mainExtension;
    private final Comparator<PathAddress> removeOrderComparator;
    private ExtensionRegistry extensionParsingRegistry;
    private ModelTestParser testParser;
    private boolean addedExtraParsers;
    private XMLMapper xmlMapper;
    private final ManagementResourceRegistration MOCK_RESOURCE_REG = new ManagementResourceRegistration(){

        public boolean isRuntimeOnly() {
            return false;
        }

        public boolean isRemote() {
            return false;
        }

        public OperationEntry getOperationEntry(PathAddress address, String operationName) {
            return null;
        }

        public OperationStepHandler getOperationHandler(PathAddress address, String operationName) {
            return null;
        }

        public DescriptionProvider getOperationDescription(PathAddress address, String operationName) {
            return null;
        }

        public Set<OperationEntry.Flag> getOperationFlags(PathAddress address, String operationName) {
            return null;
        }

        public Set<String> getAttributeNames(PathAddress address) {
            return null;
        }

        public AttributeAccess getAttributeAccess(PathAddress address, String attributeName) {
            return null;
        }

        public Set<String> getChildNames(PathAddress address) {
            return null;
        }

        public Set<PathElement> getChildAddresses(PathAddress address) {
            return null;
        }

        public DescriptionProvider getModelDescription(PathAddress address) {
            return null;
        }

        public Map<String, OperationEntry> getOperationDescriptions(PathAddress address, boolean inherited) {
            return null;
        }

        public ProxyController getProxyController(PathAddress address) {
            return null;
        }

        public Set<ProxyController> getProxyControllers(PathAddress address) {
            return null;
        }

        public ManagementResourceRegistration getOverrideModel(String name) {
            return null;
        }

        public ManagementResourceRegistration getSubModel(PathAddress address) {
            return null;
        }

        public List<AccessConstraintDefinition> getAccessConstraints() {
            return Collections.emptyList();
        }

        public ManagementResourceRegistration registerSubModel(PathElement address, DescriptionProvider descriptionProvider) {
            return SubsystemTestDelegate.this.MOCK_RESOURCE_REG;
        }

        public ManagementResourceRegistration registerSubModel(ResourceDefinition resourceDefinition) {
            return SubsystemTestDelegate.this.MOCK_RESOURCE_REG;
        }

        public void unregisterSubModel(PathElement address) {
        }

        public boolean isAllowsOverride() {
            return true;
        }

        public void setRuntimeOnly(boolean runtimeOnly) {
        }

        public ManagementResourceRegistration registerOverrideModel(String name, OverrideDescriptionProvider descriptionProvider) {
            return SubsystemTestDelegate.this.MOCK_RESOURCE_REG;
        }

        public void unregisterOverrideModel(String name) {
        }

        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider) {
        }

        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, EnumSet<OperationEntry.Flag> flags) {
        }

        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited) {
        }

        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, OperationEntry.EntryType entryType) {
        }

        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, EnumSet<OperationEntry.Flag> flags) {
        }

        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, OperationEntry.EntryType entryType, EnumSet<OperationEntry.Flag> flags) {
        }

        public void registerOperationHandler(OperationDefinition definition, OperationStepHandler handler) {
        }

        public void registerOperationHandler(OperationDefinition definition, OperationStepHandler handler, boolean inherited) {
        }

        public void unregisterOperationHandler(String operationName) {
        }

        public void registerReadWriteAttribute(String attributeName, OperationStepHandler readHandler, OperationStepHandler writeHandler, AttributeAccess.Storage storage) {
        }

        public void registerReadWriteAttribute(String attributeName, OperationStepHandler readHandler, OperationStepHandler writeHandler, EnumSet<AttributeAccess.Flag> flags) {
        }

        public void registerReadWriteAttribute(AttributeDefinition definition, OperationStepHandler readHandler, OperationStepHandler writeHandler) {
        }

        public void registerReadOnlyAttribute(String attributeName, OperationStepHandler readHandler, AttributeAccess.Storage storage) {
        }

        public void registerReadOnlyAttribute(String attributeName, OperationStepHandler readHandler, EnumSet<AttributeAccess.Flag> flags) {
        }

        public void registerReadOnlyAttribute(AttributeDefinition definition, OperationStepHandler readHandler) {
        }

        public void registerMetric(String attributeName, OperationStepHandler metricHandler) {
        }

        public void registerMetric(AttributeDefinition definition, OperationStepHandler metricHandler) {
        }

        public void registerMetric(String attributeName, OperationStepHandler metricHandler, EnumSet<AttributeAccess.Flag> flags) {
        }

        public void unregisterAttribute(String attributeName) {
        }

        public void registerProxyController(PathElement address, ProxyController proxyController) {
        }

        public void unregisterProxyController(PathElement address) {
        }

        public void registerAlias(PathElement address, AliasEntry alias) {
        }

        public void unregisterAlias(PathElement address) {
        }

        public AliasEntry getAliasEntry() {
            return null;
        }

        public boolean isAlias() {
            return false;
        }
    };

    SubsystemTestDelegate(Class<?> testClass, String mainSubsystemName, Extension mainExtension, Comparator<PathAddress> removeOrderComparator) {
        this.testClass = testClass;
        this.mainSubsystemName = mainSubsystemName;
        this.mainExtension = mainExtension;
        this.removeOrderComparator = removeOrderComparator;
    }

    String getMainSubsystemName() {
        return this.mainSubsystemName;
    }

    void initializeParser() throws Exception {
        this.xmlMapper = XMLMapper.Factory.create();
        this.extensionParsingRegistry = new ExtensionRegistry(this.getProcessType(), new RunningModeControl(RunningMode.NORMAL), null, null);
        this.testParser = new TestParser(this.mainSubsystemName, this.extensionParsingRegistry);
        this.xmlMapper.registerRootElement(new QName("urn.org.jboss.test:1.0", "test"), (XMLElementReader)this.testParser);
        this.mainExtension.initializeParsers(this.extensionParsingRegistry.getExtensionParsingContext("Test", this.xmlMapper));
        this.addedExtraParsers = false;
    }

    void cleanup() throws Exception {
        for (KernelServices kernelServices : this.kernelServices) {
            try {
                kernelServices.shutdown();
            }
            catch (Exception exception) {}
        }
        this.kernelServices.clear();
        this.xmlMapper = null;
        this.extensionParsingRegistry = null;
        this.testParser = null;
    }

    Extension getMainExtension() {
        return this.mainExtension;
    }

    List<ModelNode> parse(String subsystemXml) throws XMLStreamException {
        return this.parse(null, subsystemXml);
    }

    List<ModelNode> parse(AdditionalParsers additionalParsers, String subsystemXml) throws XMLStreamException {
        String xml = "<test xmlns=\"urn.org.jboss.test:1.0\">" + subsystemXml + "</test>";
        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(xml));
        this.addAdditionalParsers(additionalParsers);
        ArrayList<ModelNode> operationList = new ArrayList<ModelNode>();
        this.xmlMapper.parseDocument(operationList, reader);
        return operationList;
    }

    String outputModel(ModelNode model) throws Exception {
        StringConfigurationPersister persister = new StringConfigurationPersister(Collections.emptyList(), (XMLElementWriter)this.testParser, true);
        ExtensionRegistry outputExtensionRegistry = new ExtensionRegistry(ProcessType.HOST_CONTROLLER, new RunningModeControl(RunningMode.NORMAL), null, null);
        outputExtensionRegistry.setSubsystemParentResourceRegistrations(this.MOCK_RESOURCE_REG, this.MOCK_RESOURCE_REG);
        outputExtensionRegistry.setWriterRegistry((SubsystemXmlWriterRegistry)persister);
        Extension extension = (Extension)this.mainExtension.getClass().newInstance();
        extension.initialize(outputExtensionRegistry.getExtensionContext("Test", false));
        ConfigurationPersister.PersistenceResource resource = persister.store(model, Collections.emptySet());
        resource.commit();
        return persister.getMarshalled();
    }

    KernelServices installInController(String subsystemXml) throws Exception {
        return this.createKernelServicesBuilder(null).setSubsystemXml(subsystemXml).build();
    }

    KernelServices installInController(AdditionalInitialization additionalInit, String subsystemXml) throws Exception {
        return this.createKernelServicesBuilder(additionalInit).setSubsystemXml(subsystemXml).build();
    }

    KernelServices installInController(List<ModelNode> bootOperations) throws Exception {
        return this.createKernelServicesBuilder(null).setBootOperations(bootOperations).build();
    }

    KernelServices installInController(AdditionalInitialization additionalInit, List<ModelNode> bootOperations) throws Exception {
        return this.createKernelServicesBuilder(additionalInit).setBootOperations(bootOperations).build();
    }

    KernelServicesBuilder createKernelServicesBuilder(AdditionalInitialization additionalInit) {
        return new KernelServicesBuilderImpl(additionalInit);
    }

    ProcessType getProcessType() {
        return ProcessType.EMBEDDED_SERVER;
    }

    void assertRemoveSubsystemResources(KernelServices kernelServices) {
        this.assertRemoveSubsystemResources(kernelServices, null);
    }

    void assertRemoveSubsystemResources(KernelServices kernelServices, Set<PathAddress> ignoredChildAddresses) {
        if (ignoredChildAddresses == null) {
            ignoredChildAddresses = Collections.emptySet();
        } else {
            PathAddress subsystem = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)this.mainSubsystemName)});
            Assert.assertFalse((String)"Cannot exclude removal of subsystem itself", (boolean)ignoredChildAddresses.contains(subsystem));
        }
        Resource rootResource = ModelTestModelControllerService.grabRootResource((ModelTestKernelServices)kernelServices);
        ArrayList<PathAddress> addresses = new ArrayList<PathAddress>();
        PathAddress pathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)this.mainSubsystemName)});
        Resource subsystemResource = rootResource.getChild(pathAddress.getLastElement());
        Assert.assertNotNull((Object)subsystemResource);
        addresses.add(pathAddress);
        this.getAllChildAddressesForRemove(pathAddress, addresses, subsystemResource);
        if (this.removeOrderComparator != null) {
            Collections.sort(addresses, this.removeOrderComparator);
        }
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        composite.get("rollback-on-runtime-failure").set(true);
        ListIterator iterator = addresses.listIterator(addresses.size());
        while (iterator.hasPrevious()) {
            PathAddress cur = (PathAddress)iterator.previous();
            if (ignoredChildAddresses.contains(cur)) continue;
            ModelNode remove = new ModelNode();
            remove.get("operation").set("remove");
            remove.get("address").set(cur.toModelNode());
            composite.get("steps").add(remove);
        }
        kernelServices.executeOperation(composite, new InputStream[0]);
        ModelNode model = kernelServices.readWholeModel().get(new String[]{"subsystem", this.mainSubsystemName});
        Assert.assertFalse((String)("Subsystem resources were not removed " + model), (boolean)model.isDefined());
    }

    private void getAllChildAddressesForRemove(PathAddress address, List<PathAddress> addresses, Resource resource) {
        ArrayList<PathElement> childElements = new ArrayList<PathElement>();
        for (String type : resource.getChildTypes()) {
            for (String childName : resource.getChildrenNames(type)) {
                PathElement element = PathElement.pathElement((String)type, (String)childName);
                childElements.add(element);
            }
        }
        for (PathElement childElement : childElements) {
            addresses.add(address.append(new PathElement[]{childElement}));
        }
        for (PathElement childElement : childElements) {
            this.getAllChildAddressesForRemove(address.append(new PathElement[]{childElement}), addresses, resource.getChild(childElement));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    void generateLegacySubsystemResourceRegistrationDmr(KernelServices kernelServices, ModelVersion modelVersion) throws IOException {
        KernelServices legacy = (KernelServices)kernelServices.getLegacyServices(modelVersion);
        PathAddress pathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)this.mainSubsystemName)});
        ModelNode desc = ((KernelServicesInternal)((Object)legacy)).readFullModelDescription(pathAddress.toModelNode());
        File file = new File("target/test-classes").getAbsoluteFile();
        Assert.assertTrue((boolean)file.exists());
        for (String part : this.getClass().getPackage().getName().split("\\.")) {
            if ((file = new File(file, part)).exists()) continue;
            file.mkdir();
        }
        PrintWriter pw = new PrintWriter(new File(file, this.mainSubsystemName + "-" + modelVersion.getMajor() + "." + modelVersion.getMinor() + "." + modelVersion.getMicro() + ".dmr"));
        try {
            desc.writeString(pw, false);
        }
        finally {
            IoUtils.safeClose((Closeable)pw);
        }
    }

    ModelNode checkSubsystemModelTransformation(KernelServices kernelServices, ModelVersion modelVersion, ModelFixer legacyModelFixer) throws IOException {
        KernelServices legacy = (KernelServices)kernelServices.getLegacyServices(modelVersion);
        ModelNode legacyModel = legacy.readWholeModel();
        ModelNode legacySubsystem = legacyModel.require("subsystem");
        legacySubsystem = legacySubsystem.require(this.mainSubsystemName);
        if (legacyModelFixer != null) {
            legacySubsystem = legacyModelFixer.fixModel(legacySubsystem);
        }
        ModelNode transformed = kernelServices.readTransformedModel(modelVersion).get(new String[]{"subsystem", this.mainSubsystemName});
        ModelTestUtils.compare((ModelNode)legacySubsystem, (ModelNode)transformed, (boolean)true);
        ResourceDefinition rd = TransformerRegistry.loadSubsystemDefinitionFromFile(this.getClass(), (String)this.mainSubsystemName, (ModelVersion)modelVersion);
        Assert.assertNotNull((String)("Could not load legacy dmr for subsystem '" + this.mainSubsystemName + "' version: '" + modelVersion + "' please add it"), (Object)rd);
        ManagementResourceRegistration rr = ManagementResourceRegistration.Factory.create((ResourceDefinition)rd);
        ModelTestUtils.checkModelAgainstDefinition((ModelNode)transformed, (ManagementResourceRegistration)rr);
        return legacyModel;
    }

    void addAdditionalParsers(AdditionalParsers additionalParsers) {
        if (additionalParsers != null && !this.addedExtraParsers) {
            additionalParsers.addParsers(this.extensionParsingRegistry, this.xmlMapper);
            this.addedExtraParsers = true;
        }
    }

    private ExtensionRegistry cloneExtensionRegistry(AdditionalInitialization additionalInit) {
        ExtensionRegistry clone = new ExtensionRegistry(additionalInit.getProcessType(), new RunningModeControl(additionalInit.getExtensionRegistryRunningMode()), null, null);
        for (String extension : this.extensionParsingRegistry.getExtensionModuleNames()) {
            ExtensionParsingContext epc = clone.getExtensionParsingContext(extension, null);
            for (Map.Entry entry : this.extensionParsingRegistry.getAvailableSubsystems(extension).entrySet()) {
                for (String namespace : ((SubsystemInformation)entry.getValue()).getXMLNamespaces()) {
                    epc.setSubsystemXmlMapping((String)entry.getKey(), namespace, null);
                }
            }
        }
        return clone;
    }

    private void validateDescriptionProviders(AdditionalInitialization additionalInit, KernelServices kernelServices) {
        ModelDescriptionValidator.ValidationConfiguration arbitraryDescriptors = additionalInit.getModelValidationConfiguration();
        ModelNode address = new ModelNode();
        address.setEmptyList();
        address.add("subsystem", this.mainSubsystemName);
        ModelNode op = new ModelNode();
        op.get("operation").set("read-resource-description");
        op.get("address").set(address);
        op.get("recursive").set(true);
        op.get("inherited").set(false);
        op.get("operations").set(true);
        op.get("include-aliases").set(true);
        ModelNode result = kernelServices.executeOperation(op, new InputStream[0]);
        if (result.hasDefined("failure-description")) {
            throw new RuntimeException(result.get("failure-description").toString());
        }
        ModelNode model = result.get("result");
        ModelDescriptionValidator validator = new ModelDescriptionValidator(address, model, arbitraryDescriptors);
        List<ModelDescriptionValidator.ValidationFailure> validationMessages = validator.validateResource();
        if (validationMessages.size() > 0) {
            StringBuilder builder = new StringBuilder("VALIDATION ERRORS IN MODEL:");
            for (ModelDescriptionValidator.ValidationFailure failure : validationMessages) {
                builder.append((Object)failure);
                builder.append("\n");
            }
            if (arbitraryDescriptors != null) {
                Assert.fail((String)("Failed due to validation errors in the model. Please fix :-) " + builder.toString()));
            }
        }
    }

    static {
        SUCCESS.get("outcome").set("success");
        SUCCESS.get("result");
        SUCCESS.protect();
    }

    private class LegacyKernelServiceInitializerImpl
    implements LegacyKernelServicesInitializer {
        private final AdditionalInitialization additionalInit;
        private final ModelTestControllerVersion testControllerVersion;
        private String extensionClassName;
        private ModelVersion modelVersion;
        private ChildFirstClassLoaderBuilder classLoaderBuilder = new ChildFirstClassLoaderBuilder();
        private ModelTestOperationValidatorFilter.Builder operationValidationExcludeBuilder;
        private boolean persistXml = true;
        private boolean skipReverseCheck;
        private AdditionalInitialization reverseCheckConfig;
        private ModelFixer reverseCheckModelFixer;
        private OperationFixer reverseCheckOperationFixer = new OperationFixer(){

            public ModelNode fixOperation(ModelNode operation) {
                return operation;
            }
        };

        public LegacyKernelServiceInitializerImpl(AdditionalInitialization additionalInit, ModelTestControllerVersion version, ModelVersion modelVersion) {
            this.additionalInit = additionalInit == null ? AdditionalInitialization.MANAGEMENT : additionalInit;
            this.testControllerVersion = version;
            this.modelVersion = modelVersion;
        }

        @Override
        public LegacyKernelServicesInitializer addOperationValidationExclude(String name, PathAddress pathAddress) {
            this.addOperationValidationConfig(name, pathAddress, ModelTestOperationValidatorFilter.Action.NOCHECK);
            return this;
        }

        @Override
        public LegacyKernelServicesInitializer addOperationValidationResolve(String name, PathAddress pathAddress) {
            this.addOperationValidationConfig(name, pathAddress, ModelTestOperationValidatorFilter.Action.RESOLVE);
            return this;
        }

        private void addOperationValidationConfig(String name, PathAddress pathAddress, ModelTestOperationValidatorFilter.Action action) {
            if (!this.additionalInit.isValidateOperations()) {
                throw new IllegalStateException("The additional initialization used to create this builder has turned off operation validation. That is not compatible with calling this method");
            }
            if (this.operationValidationExcludeBuilder == null) {
                this.operationValidationExcludeBuilder = ModelTestOperationValidatorFilter.createBuilder();
            }
            this.operationValidationExcludeBuilder.addOperation(pathAddress, name, action);
        }

        @Override
        public LegacyKernelServicesInitializer setExtensionClassName(String extensionClassName) {
            this.extensionClassName = extensionClassName;
            return this;
        }

        @Override
        public LegacyKernelServicesInitializer addURL(URL url) {
            this.classLoaderBuilder.addURL(url);
            return this;
        }

        @Override
        public LegacyKernelServicesInitializer addSimpleResourceURL(String resource) throws MalformedURLException {
            this.classLoaderBuilder.addSimpleResourceURL(resource);
            return this;
        }

        @Override
        public LegacyKernelServicesInitializer addMavenResourceURL(String artifactGav) throws IOException, ClassNotFoundException {
            this.classLoaderBuilder.addMavenResourceURL(artifactGav);
            return this;
        }

        @Override
        public LegacyKernelServiceInitializerImpl addParentFirstClassPattern(String pattern) {
            this.classLoaderBuilder.addParentFirstClassPattern(pattern);
            return this;
        }

        @Override
        public LegacyKernelServiceInitializerImpl addChildFirstClassPattern(String pattern) {
            this.classLoaderBuilder.addChildFirstClassPattern(pattern);
            return this;
        }

        @Override
        public LegacyKernelServicesInitializer excludeFromParent(ClassFilter exclusionFilter) {
            this.classLoaderBuilder.excludeFromParent(exclusionFilter);
            return this;
        }

        private LegacyControllerKernelServicesProxy install(KernelServices mainServices, List<ModelNode> bootOperations) throws Exception {
            if (!this.skipReverseCheck) {
                this.bootCurrentVersionWithLegacyBootOperations(bootOperations, mainServices);
            }
            this.classLoaderBuilder.addParentFirstClassPattern("org.jboss.as.subsystem.bridge.shared.*");
            this.classLoaderBuilder.addMavenResourceURL("org.wildfly:wildfly-subsystem-test-framework:" + ModelTestControllerVersion.CurrentVersion.VERSION);
            this.classLoaderBuilder.addMavenResourceURL("org.wildfly:wildfly-model-test:" + ModelTestControllerVersion.CurrentVersion.VERSION);
            if (this.testControllerVersion != ModelTestControllerVersion.MASTER) {
                String groupId = this.testControllerVersion.getMavenGavVersion().startsWith("7.") ? "org.jboss.as" : "org.wildfly";
                String serverArtifactId = this.testControllerVersion.getMavenGavVersion().startsWith("7.") ? "jboss-as-server" : "wildfly-server";
                this.classLoaderBuilder.addRecursiveMavenResourceURL(groupId + ":" + serverArtifactId + ":" + this.testControllerVersion.getMavenGavVersion(), new String[0]);
                this.classLoaderBuilder.addParentFirstClassPattern("__redirected.*");
                this.classLoaderBuilder.addParentFirstClassPattern("org.jboss.modules.*");
                this.classLoaderBuilder.addMavenResourceURL("org.wildfly:wildfly-subsystem-test-controller-" + this.testControllerVersion.getTestControllerVersion() + ":" + ModelTestControllerVersion.CurrentVersion.VERSION);
            }
            ClassLoader legacyCl = this.classLoaderBuilder.build();
            ScopedKernelServicesBootstrap scopedBootstrap = new ScopedKernelServicesBootstrap(legacyCl);
            return scopedBootstrap.createKernelServices(SubsystemTestDelegate.this.mainSubsystemName, this.extensionClassName != null ? this.extensionClassName : SubsystemTestDelegate.this.mainExtension.getClass().getName(), this.additionalInit, this.getOperationValidationFilter(), bootOperations, this.modelVersion, this.persistXml);
        }

        @Override
        public LegacyKernelServicesInitializer dontPersistXml() {
            this.persistXml = false;
            return this;
        }

        @Override
        public LegacyKernelServicesInitializer skipReverseControllerCheck() {
            this.skipReverseCheck = true;
            return this;
        }

        @Override
        public LegacyKernelServicesInitializer configureReverseControllerCheck(AdditionalInitialization additionalInit, ModelFixer modelFixer) {
            this.reverseCheckConfig = additionalInit;
            this.reverseCheckModelFixer = modelFixer;
            return this;
        }

        @Override
        public LegacyKernelServicesInitializer configureReverseControllerCheck(AdditionalInitialization additionalInit, ModelFixer modelFixer, OperationFixer fixer) {
            this.reverseCheckConfig = additionalInit;
            this.reverseCheckModelFixer = modelFixer;
            this.reverseCheckOperationFixer = fixer;
            return this;
        }

        private KernelServices bootCurrentVersionWithLegacyBootOperations(List<ModelNode> bootOperations, KernelServices mainServices) throws Exception {
            ArrayList<ModelNode> clonedBootOperations = new ArrayList<ModelNode>();
            for (ModelNode op : bootOperations) {
                ModelNode cloned = this.reverseCheckOperationFixer.fixOperation(op.clone());
                if (cloned == null) continue;
                clonedBootOperations.add(cloned);
            }
            KernelServices reverseServices = SubsystemTestDelegate.this.createKernelServicesBuilder(this.reverseCheckConfig).setBootOperations(clonedBootOperations).build();
            if (reverseServices.getBootError() != null) {
                Throwable t = reverseServices.getBootError();
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new Exception(t);
            }
            Assert.assertTrue((boolean)reverseServices.isSuccessfulBoot());
            ModelNode reverseSubsystem = reverseServices.readWholeModel().get(new String[]{"subsystem", SubsystemTestDelegate.this.getMainSubsystemName()});
            if (this.reverseCheckModelFixer != null) {
                this.reverseCheckModelFixer.fixModel(reverseSubsystem);
            }
            ModelTestUtils.compare((ModelNode)mainServices.readWholeModel().get(new String[]{"subsystem", SubsystemTestDelegate.this.getMainSubsystemName()}), (ModelNode)reverseSubsystem);
            return reverseServices;
        }

        private ModelTestOperationValidatorFilter getOperationValidationFilter() {
            if (this.operationValidationExcludeBuilder != null) {
                return this.operationValidationExcludeBuilder.build();
            }
            if (this.additionalInit.isValidateOperations()) {
                return ModelTestOperationValidatorFilter.createValidateAll();
            }
            return ModelTestOperationValidatorFilter.createValidateNone();
        }
    }

    private class KernelServicesBuilderImpl
    implements KernelServicesBuilder,
    ModelTestBootOperationsBuilder.BootOperationParser {
        private final ModelTestBootOperationsBuilder bootOperationBuilder;
        private final AdditionalInitialization additionalInit;
        private Map<ModelVersion, LegacyKernelServiceInitializerImpl> legacyControllerInitializers = new HashMap<ModelVersion, LegacyKernelServiceInitializerImpl>();

        public KernelServicesBuilderImpl(AdditionalInitialization additionalInit) {
            this.additionalInit = additionalInit == null ? new AdditionalInitialization() : additionalInit;
            this.bootOperationBuilder = new ModelTestBootOperationsBuilder(SubsystemTestDelegate.this.testClass, (ModelTestBootOperationsBuilder.BootOperationParser)this);
        }

        @Override
        public KernelServicesBuilder setSubsystemXmlResource(String resource) throws IOException, XMLStreamException {
            this.bootOperationBuilder.setXmlResource(resource);
            return this;
        }

        @Override
        public KernelServicesBuilder setSubsystemXml(String subsystemXml) throws XMLStreamException {
            this.bootOperationBuilder.setXml(subsystemXml);
            return this;
        }

        @Override
        public KernelServicesBuilder setBootOperations(List<ModelNode> bootOperations) {
            this.bootOperationBuilder.setBootOperations(bootOperations);
            return this;
        }

        @Override
        public KernelServicesBuilder setBootOperations(ModelNode ... bootOperations) {
            this.bootOperationBuilder.setBootOperations(Arrays.asList(bootOperations));
            return this;
        }

        @Override
        public LegacyKernelServicesInitializer createLegacyKernelServicesBuilder(AdditionalInitialization additionalInit, ModelTestControllerVersion version, ModelVersion modelVersion) {
            this.bootOperationBuilder.validateNotAlreadyBuilt();
            if (this.legacyControllerInitializers.containsKey(modelVersion)) {
                throw new IllegalArgumentException("There is already a legacy controller for " + modelVersion);
            }
            if (additionalInit != null && additionalInit.getRunningMode() != RunningMode.ADMIN_ONLY) {
                throw new IllegalArgumentException("The additional initialization must have a running mode of ADMIN_ONLY, it was " + additionalInit.getRunningMode());
            }
            LegacyKernelServiceInitializerImpl initializer = new LegacyKernelServiceInitializerImpl(additionalInit, version, modelVersion);
            this.legacyControllerInitializers.put(modelVersion, initializer);
            return initializer;
        }

        @Override
        public KernelServices build() throws Exception {
            this.bootOperationBuilder.validateNotAlreadyBuilt();
            List bootOperations = this.bootOperationBuilder.build();
            AbstractKernelServicesImpl kernelServices = AbstractKernelServicesImpl.create(SubsystemTestDelegate.this.mainSubsystemName, this.additionalInit, ModelTestOperationValidatorFilter.createValidateAll(), SubsystemTestDelegate.this.cloneExtensionRegistry(this.additionalInit), bootOperations, SubsystemTestDelegate.this.testParser, SubsystemTestDelegate.this.mainExtension, null, this.legacyControllerInitializers.size() > 0, true);
            SubsystemTestDelegate.this.kernelServices.add(kernelServices);
            SubsystemTestDelegate.this.validateDescriptionProviders(this.additionalInit, kernelServices);
            ImmutableManagementResourceRegistration subsystemReg = kernelServices.getRootRegistration().getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)SubsystemTestDelegate.this.mainSubsystemName)}));
            ModelTestUtils.validateModelDescriptions((PathAddress)PathAddress.EMPTY_ADDRESS, (ImmutableManagementResourceRegistration)subsystemReg);
            for (Map.Entry<ModelVersion, LegacyKernelServiceInitializerImpl> entry : this.legacyControllerInitializers.entrySet()) {
                LegacyKernelServiceInitializerImpl legacyInitializer = entry.getValue();
                ArrayList<ModelNode> transformedBootOperations = new ArrayList<ModelNode>();
                for (ModelNode op : bootOperations) {
                    OperationTransformer.TransformedOperation transformedOp = kernelServices.transformOperation(entry.getKey(), op);
                    if (transformedOp.getTransformedOperation() == null || transformedOp.rejectOperation(SUCCESS)) continue;
                    transformedBootOperations.add(transformedOp.getTransformedOperation());
                }
                LegacyControllerKernelServicesProxy legacyServices = legacyInitializer.install(kernelServices, transformedBootOperations);
                kernelServices.addLegacyKernelService(entry.getKey(), legacyServices);
            }
            return kernelServices;
        }

        public List<ModelNode> parse(String subsystemXml) throws XMLStreamException {
            return SubsystemTestDelegate.this.parse(this.additionalInit, subsystemXml);
        }

        @Override
        public List<ModelNode> parseXml(String xml) throws Exception {
            ModelTestBootOperationsBuilder builder = new ModelTestBootOperationsBuilder(SubsystemTestDelegate.this.testClass, (ModelTestBootOperationsBuilder.BootOperationParser)this);
            builder.setXml(xml);
            return builder.build();
        }

        @Override
        public List<ModelNode> parseXmlResource(String xmlResource) throws Exception {
            ModelTestBootOperationsBuilder builder = new ModelTestBootOperationsBuilder(SubsystemTestDelegate.this.testClass, (ModelTestBootOperationsBuilder.BootOperationParser)this);
            builder.setXmlResource(xmlResource);
            return builder.build();
        }
    }
}

