/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.moduleservice;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.moduleservice.ModuleDefinition;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleNotFoundException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ModuleLoadService
implements Service<Module> {
    private final InjectedValue<ServiceModuleLoader> serviceModuleLoader = new InjectedValue();
    private final InjectedValue<ModuleDefinition> moduleDefinitionInjectedValue = new InjectedValue();
    private final List<ModuleDependency> dependencies;
    private volatile Module module;

    private ModuleLoadService(List<ModuleDependency> dependencies) {
        this.dependencies = dependencies;
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            ServiceModuleLoader moduleLoader = (ServiceModuleLoader)((Object)this.serviceModuleLoader.getValue());
            Module module = moduleLoader.loadModule(((ModuleDefinition)this.moduleDefinitionInjectedValue.getValue()).getModuleIdentifier());
            moduleLoader.relinkModule(module);
            for (ModuleDependency dependency : this.dependencies) {
                if (!dependency.isUserSpecified()) continue;
                ModuleIdentifier id = dependency.getIdentifier();
                try {
                    String val = moduleLoader.loadModule(id).getProperty("jboss.api");
                    if (val == null) continue;
                    if (val.equals("private")) {
                        ServerLogger.PRIVATE_DEP_LOGGER.privateApiUsed(((ModuleDefinition)this.moduleDefinitionInjectedValue.getValue()).getModuleIdentifier().getName(), id);
                        continue;
                    }
                    if (!val.equals("unsupported")) continue;
                    ServerLogger.UNSUPPORTED_DEP_LOGGER.unsupportedApiUsed(((ModuleDefinition)this.moduleDefinitionInjectedValue.getValue()).getModuleIdentifier().getName(), id);
                }
                catch (ModuleNotFoundException ignore) {}
            }
            this.module = module;
        }
        catch (ModuleLoadException e) {
            throw ServerMessages.MESSAGES.failedToLoadModule(((ModuleDefinition)this.moduleDefinitionInjectedValue.getValue()).getModuleIdentifier(), e);
        }
    }

    public synchronized void stop(StopContext context) {
        this.module = null;
    }

    public Module getValue() throws IllegalStateException, IllegalArgumentException {
        return this.module;
    }

    public static ServiceName install(ServiceTarget target, ModuleIdentifier identifier, List<ModuleDependency> dependencies) {
        ModuleLoadService service = new ModuleLoadService(dependencies);
        ServiceName serviceName = ServiceModuleLoader.moduleServiceName(identifier);
        ServiceBuilder builder = target.addService(serviceName, (Service)service);
        builder.addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ServiceModuleLoader.class, service.getServiceModuleLoader());
        builder.addDependency(ServiceModuleLoader.moduleSpecServiceName(identifier), ModuleDefinition.class, service.getModuleDefinitionInjectedValue());
        builder.addDependency(ServiceModuleLoader.moduleResolvedServiceName(identifier));
        for (ModuleDependency dependency : dependencies) {
            ModuleIdentifier moduleIdentifier = dependency.getIdentifier();
            if (!moduleIdentifier.getName().startsWith("deployment.")) continue;
            builder.addDependency(dependency.isOptional() ? ServiceBuilder.DependencyType.OPTIONAL : ServiceBuilder.DependencyType.REQUIRED, ServiceModuleLoader.moduleSpecServiceName(moduleIdentifier));
        }
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
        return serviceName;
    }

    public static ServiceName installService(ServiceTarget target, ModuleIdentifier identifier, List<ModuleIdentifier> identifiers) {
        ArrayList<ModuleDependency> dependencies = new ArrayList<ModuleDependency>(identifiers.size());
        for (ModuleIdentifier i : identifiers) {
            dependencies.add(new ModuleDependency(null, i, false, false, false, false));
        }
        return ModuleLoadService.install(target, identifier, dependencies);
    }

    public InjectedValue<ServiceModuleLoader> getServiceModuleLoader() {
        return this.serviceModuleLoader;
    }

    public InjectedValue<ModuleDefinition> getModuleDefinitionInjectedValue() {
        return this.moduleDefinitionInjectedValue;
    }
}

