/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.management;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Map;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.patching.installation.InstallationManager;
import org.jboss.as.patching.installation.InstallationManagerService;
import org.jboss.as.patching.installation.InstalledImage;
import org.jboss.as.patching.installation.Layer;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.management.PatchManagementMessages;
import org.jboss.as.patching.tool.PatchingHistory;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class LocalAgeoutHistoryHandler
implements OperationStepHandler {
    public static final LocalAgeoutHistoryHandler INSTANCE = new LocalAgeoutHistoryHandler();
    static final FilenameFilter ALL = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return true;
        }
    };
    static final FilenameFilter HISTORY_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !"patch.xml".equals(name) && !"rollback.xml".equals(name);
        }
    };

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PatchableTarget.TargetInfo info;
        context.acquireControllerLock();
        ServiceController mgrService = context.getServiceRegistry(true).getRequiredService(InstallationManagerService.NAME);
        InstallationManager mgr = (InstallationManager)mgrService.getValue();
        InstalledImage installedImage = mgr.getInstalledImage();
        try {
            info = mgr.getIdentity().loadTargetInfo();
        }
        catch (IOException e) {
            throw new OperationFailedException(PatchManagementMessages.MESSAGES.failedToLoadIdentity(), (Throwable)e);
        }
        PatchingHistory.Iterator i = PatchingHistory.Factory.iterator(mgr, info);
        if (i.hasNextCP()) {
            i.nextCP();
            while (i.hasNext()) {
                File patchHistoryDir;
                PatchingHistory.Entry entry = (PatchingHistory.Entry)i.next();
                Map<String, String> layerPatches = entry.getLayerPatches();
                if (!layerPatches.isEmpty()) {
                    for (String layerName : layerPatches.keySet()) {
                        Layer layer = mgr.getLayer(layerName);
                        if (layer == null) {
                            throw new OperationFailedException(PatchManagementMessages.MESSAGES.layerNotFound(layerName));
                        }
                        File patchDir = layer.getDirectoryStructure().getModulePatchDirectory(layerPatches.get(layerName));
                        if (!patchDir.exists()) continue;
                        LocalAgeoutHistoryHandler.recursiveDelete(patchDir);
                    }
                }
                if (!(patchHistoryDir = installedImage.getPatchHistoryDir(entry.getPatchId())).exists()) continue;
                LocalAgeoutHistoryHandler.recursiveDelete(patchHistoryDir, HISTORY_FILTER);
            }
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    static boolean recursiveDelete(File root) {
        return LocalAgeoutHistoryHandler.recursiveDelete(root, ALL);
    }

    static boolean recursiveDelete(File root, FilenameFilter filter) {
        boolean ok = true;
        if (root.isDirectory()) {
            File[] files;
            for (File file : files = root.listFiles(filter)) {
                ok &= LocalAgeoutHistoryHandler.recursiveDelete(file, filter);
            }
            return ok && (root.delete() || !root.exists());
        }
        return ok &= root.delete() || !root.exists();
    }
}

