/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.installation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.patching.installation.AddOn;
import org.jboss.as.patching.installation.Identity;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.installation.InstalledImage;
import org.jboss.as.patching.installation.Layer;

public class InstalledIdentityImpl
extends InstalledIdentity {
    private final Identity identity;
    private final InstalledImage installedImage;
    private final List<String> allPatches;
    private final Map<String, Layer> layers = new LinkedHashMap<String, Layer>();
    private final Map<String, AddOn> addOns = new LinkedHashMap<String, AddOn>();

    protected InstalledIdentityImpl(Identity identity, List<String> allPatches, InstalledImage installedImage) {
        this.identity = identity;
        this.installedImage = installedImage;
        this.allPatches = Collections.unmodifiableList(allPatches);
    }

    @Override
    public List<String> getAllInstalledPatches() {
        return this.allPatches;
    }

    @Override
    public Identity getIdentity() {
        return this.identity;
    }

    @Override
    public List<Layer> getLayers() {
        ArrayList<Layer> layers = new ArrayList<Layer>(this.layers.values());
        return Collections.unmodifiableList(layers);
    }

    @Override
    public List<String> getLayerNames() {
        ArrayList<String> layerNames = new ArrayList<String>(this.layers.keySet());
        return Collections.unmodifiableList(layerNames);
    }

    @Override
    public Layer getLayer(String layerName) {
        return this.layers.get(layerName);
    }

    @Override
    public Collection<String> getAddOnNames() {
        return Collections.unmodifiableCollection(this.addOns.keySet());
    }

    @Override
    public AddOn getAddOn(String addOnName) {
        return this.addOns.get(addOnName);
    }

    @Override
    public Collection<AddOn> getAddOns() {
        return Collections.unmodifiableCollection(this.addOns.values());
    }

    @Override
    public InstalledImage getInstalledImage() {
        return this.installedImage;
    }

    protected Layer putLayer(String name, Layer layer) {
        return this.layers.put(name, layer);
    }

    protected AddOn putAddOn(String name, AddOn addOn) {
        return this.addOns.put(name, addOn);
    }
}

