/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.validation;

import java.io.File;
import org.jboss.as.patching.validation.AbstractArtifact;
import org.jboss.as.patching.validation.AppliedAtArtifact;
import org.jboss.as.patching.validation.Artifact;
import org.jboss.as.patching.validation.Context;
import org.jboss.as.patching.validation.PatchArtifact;
import org.jboss.as.patching.validation.PatchXmlArtifact;
import org.jboss.as.patching.validation.RollbackXmlArtifact;

public class PatchHistoryDir
extends AbstractArtifact<PatchArtifact.State, State> {
    public static final PatchHistoryDir INSTANCE = new PatchHistoryDir();

    private PatchHistoryDir() {
        this.addArtifact(PatchXmlArtifact.INSTANCE);
        this.addArtifact(RollbackXmlArtifact.INSTANCE);
    }

    @Override
    protected State getInitialState(PatchArtifact.State patch, Context ctx) {
        State historyDir = patch.getHistoryDir();
        if (historyDir != null) {
            return historyDir;
        }
        File dir = ctx.getInstallationManager().getInstalledImage().getPatchHistoryDir(patch.getPatchId());
        historyDir = new State(dir);
        patch.setHistoryDir(historyDir);
        return historyDir;
    }

    public static class State
    implements Artifact.State {
        private final File dir;
        private PatchXmlArtifact.State patchXml;
        private RollbackXmlArtifact.State rollbackXml;
        private AppliedAtArtifact.State appliedAt;

        State(File dir) {
            this.dir = dir;
        }

        public File getDirectory() {
            return this.dir;
        }

        public RollbackXmlArtifact.State getRollbackXml() {
            return this.rollbackXml;
        }

        public void setRollbackXml(RollbackXmlArtifact.State rollbackXml) {
            this.rollbackXml = rollbackXml;
        }

        public PatchXmlArtifact.State getPatchXml() {
            return this.patchXml;
        }

        public void setPatchXml(PatchXmlArtifact.State patchXml) {
            this.patchXml = patchXml;
        }

        public AppliedAtArtifact.State getAppliedAt() {
            return this.appliedAt;
        }

        public void setAppliedAt(AppliedAtArtifact.State appliedAt) {
            this.appliedAt = appliedAt;
        }

        @Override
        public void validate(Context ctx) {
        }
    }
}

