/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.File;
import java.io.IOException;
import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.metadata.MiscContentItem;
import org.jboss.as.patching.metadata.ModificationType;
import org.jboss.as.patching.runner.BundlePatchingTask;
import org.jboss.as.patching.runner.FileAddTask;
import org.jboss.as.patching.runner.FileRemoveTask;
import org.jboss.as.patching.runner.FileUpdateTask;
import org.jboss.as.patching.runner.ModuleRemoveTask;
import org.jboss.as.patching.runner.ModuleRollbackTask;
import org.jboss.as.patching.runner.ModuleUpdateTask;
import org.jboss.as.patching.runner.PatchingTaskContext;
import org.jboss.as.patching.runner.PatchingTaskDescription;

public interface PatchingTask {
    public ContentItem getContentItem();

    public boolean prepare(PatchingTaskContext var1) throws IOException;

    public void execute(PatchingTaskContext var1) throws IOException;

    public static final class Factory {
        static PatchingTask create(PatchingTaskDescription description, PatchingTaskContext context) {
            ContentItem item = description.getContentItem();
            switch (item.getContentType()) {
                case BUNDLE: {
                    return Factory.createBundleTask(description);
                }
                case MISC: {
                    return Factory.createMiscTask(description, (MiscContentItem)item, context);
                }
                case MODULE: {
                    return Factory.createModuleTask(description, context.getCurrentMode());
                }
            }
            throw new IllegalStateException();
        }

        static PatchingTask createBundleTask(PatchingTaskDescription description) {
            return new BundlePatchingTask(description);
        }

        static PatchingTask createModuleTask(PatchingTaskDescription description, PatchingTaskContext.Mode mode) {
            if (mode == PatchingTaskContext.Mode.APPLY) {
                ModificationType type = description.getModificationType();
                if (type == ModificationType.REMOVE) {
                    return new ModuleRemoveTask(description);
                }
                return new ModuleUpdateTask(description);
            }
            return new ModuleRollbackTask(description);
        }

        static PatchingTask createMiscTask(PatchingTaskDescription description, MiscContentItem item, PatchingTaskContext context) {
            File target = context.getTargetFile(item);
            File backup = context.getBackupFile(item);
            ModificationType type = description.getModificationType();
            switch (type) {
                case ADD: {
                    return new FileAddTask(description, target, backup);
                }
                case MODIFY: {
                    return new FileUpdateTask(description, target, backup);
                }
                case REMOVE: {
                    return new FileRemoveTask(description, target, backup);
                }
            }
            throw new IllegalStateException();
        }
    }
}

