/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public abstract class AbstractDiscoveryOptionRemoveHandler
extends AbstractRemoveStepHandler {
    public static final String OPERATION_NAME = "remove";

    protected void updateDiscoveryOptionsOrdering(OperationContext context, ModelNode operation, String type) {
        PathAddress operationAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress discoveryOptionsAddress = operationAddress.subAddress(0, operationAddress.size() - 1);
        ModelNode discoveryOptions = Resource.Tools.readModel((Resource)context.readResourceFromRoot(discoveryOptionsAddress));
        ModelNode discoveryOptionsOrdering = discoveryOptions.get("discovery-options");
        String name = Util.getNameFromAddress((ModelNode)operation.get("address"));
        ModelNode newDiscoveryOptionsOrdering = new ModelNode();
        for (Property prop : discoveryOptionsOrdering.asPropertyList()) {
            String discoveryOptionType = prop.getName();
            String discoveryOptionName = prop.getValue().asString();
            if (discoveryOptionName.equals(name) && discoveryOptionType.equals(type)) continue;
            newDiscoveryOptionsOrdering.add(discoveryOptionType, discoveryOptionName);
        }
        ModelNode writeOp = Util.getWriteAttributeOperation((PathAddress)discoveryOptionsAddress, (String)"discovery-options", (ModelNode)newDiscoveryOptionsOrdering);
        OperationStepHandler writeHandler = context.getRootResourceRegistration().getSubModel(discoveryOptionsAddress).getOperationHandler(PathAddress.EMPTY_ADDRESS, "write-attribute");
        context.addStep(new ModelNode(), writeOp, writeHandler, OperationContext.Stage.MODEL, true);
    }
}

