/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.transformers;

import java.util.Map;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.AddNameFromAddressResourceTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.as.controller.transform.TransformersSubRegistration;
import org.jboss.as.domain.controller.transformers.DeploymentTransformers;
import org.jboss.as.domain.controller.transformers.JSFSubsystemTransformers;
import org.jboss.as.domain.controller.transformers.PathsTransformers;
import org.jboss.as.domain.controller.transformers.ServerGroupTransformers;
import org.jboss.as.domain.controller.transformers.SocketBindingGroupTransformers;
import org.jboss.as.domain.controller.transformers.SystemPropertyTransformers;

public class DomainTransformers {
    static final ModelVersion IGNORED_SUBSYSTEMS = ModelVersion.create((int)-1);
    private static final PathElement JSF_EXTENSION = PathElement.pathElement((String)"extension", (String)"org.jboss.as.jsf");
    private static final ModelVersion VERSION_1_2 = ModelVersion.create((int)1, (int)2, (int)0);
    private static final ModelVersion VERSION_1_3 = ModelVersion.create((int)1, (int)3, (int)0);
    private static final ModelVersion VERSION_1_4 = ModelVersion.create((int)1, (int)4, (int)0);
    private static final ResourceTransformer IGNORED_EXTENSIONS = new IgnoreExtensionResourceTransformer();

    public static void initializeDomainRegistry(TransformerRegistry registry) {
        DomainTransformers.initializeDomainRegistry(registry, VERSION_1_2);
        DomainTransformers.initializeDomainRegistry(registry, VERSION_1_3);
        DomainTransformers.initializeDomainRegistry(registry, VERSION_1_4);
    }

    private static void initializeDomainRegistry(TransformerRegistry registry, ModelVersion modelVersion) {
        TransformersSubRegistration domain = registry.getDomainRegistration((ModelVersionRange)modelVersion);
        if (modelVersion == VERSION_1_2 || modelVersion == VERSION_1_3) {
            domain.registerSubResource(JSF_EXTENSION, IGNORED_EXTENSIONS);
            JSFSubsystemTransformers.registerTransformers120(registry, domain);
            PathsTransformers.registerTransformers120(domain);
            DeploymentTransformers.registerTransformers120(domain);
            SystemPropertyTransformers.registerTransformers120(domain);
            SocketBindingGroupTransformers.registerTransformers120(domain);
            ServerGroupTransformers.registerTransformers120(domain);
            domain.registerSubResource(PathElement.pathElement((String)"interface"), (ResourceTransformer)AddNameFromAddressResourceTransformer.INSTANCE);
            domain.registerSubResource(PathElement.pathElement((String)"path"), (ResourceTransformer)AddNameFromAddressResourceTransformer.INSTANCE);
        } else if (modelVersion == VERSION_1_4) {
            domain.registerSubResource(PathElement.pathElement((String)"interface"), (ResourceTransformer)AddNameFromAddressResourceTransformer.INSTANCE);
            domain.registerSubResource(PathElement.pathElement((String)"path"), (ResourceTransformer)AddNameFromAddressResourceTransformer.INSTANCE);
        }
    }

    static class IgnoreExtensionResourceTransformer
    implements ResourceTransformer {
        IgnoreExtensionResourceTransformer() {
        }

        public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
            PathElement element = address.getLastElement();
            TransformationTarget target = context.getTarget();
            ExtensionRegistry registry = target.getExtensionRegistry();
            Map subsystems = registry.getAvailableSubsystems(element.getValue());
            if (subsystems != null) {
                for (Map.Entry subsystem : subsystems.entrySet()) {
                    String name = (String)subsystem.getKey();
                    target.addSubsystemVersion(name, IGNORED_SUBSYSTEMS);
                }
            }
        }
    }
}

