/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.schedule.attribute;

import org.jboss.as.ejb3.timerservice.schedule.attribute.IntegerBasedExpression;
import org.jboss.as.ejb3.timerservice.schedule.value.ScheduleExpressionType;

public class Hour
extends IntegerBasedExpression {
    public static final Integer MAX_HOUR = 23;
    public static final Integer MIN_HOUR = 0;

    public Hour(String value) {
        super(value);
    }

    public int getFirst() {
        if (this.scheduleExpressionType == ScheduleExpressionType.WILDCARD) {
            return 0;
        }
        return (Integer)this.absoluteValues.first();
    }

    @Override
    protected Integer getMaxValue() {
        return MAX_HOUR;
    }

    @Override
    protected Integer getMinValue() {
        return MIN_HOUR;
    }

    @Override
    public boolean isRelativeValue(String value) {
        return false;
    }

    @Override
    protected boolean accepts(ScheduleExpressionType scheduleExprType) {
        switch (scheduleExprType) {
            case RANGE: 
            case LIST: 
            case SINGLE_VALUE: 
            case WILDCARD: 
            case INCREMENT: {
                return true;
            }
        }
        return false;
    }

    public Integer getNextMatch(int currentHour) {
        if (this.scheduleExpressionType == ScheduleExpressionType.WILDCARD) {
            return currentHour;
        }
        if (this.absoluteValues.isEmpty()) {
            return null;
        }
        for (Integer hour : this.absoluteValues) {
            if (currentHour == hour) {
                return currentHour;
            }
            if (hour <= currentHour) continue;
            return hour;
        }
        return (Integer)this.absoluteValues.first();
    }
}

