/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.CapabilityServiceTarget;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.ejb3.subsystem.DatabaseDataStoreResourceDefinition;
import org.jboss.as.ejb3.subsystem.TimerPersistenceResourceDefinition;
import org.jboss.as.ejb3.subsystem.TimerServiceResourceDefinition;
import org.jboss.as.ejb3.timerservice.persistence.database.DatabaseTimerPersistence;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.wildfly.security.manager.WildFlySecurityManager;

public class DatabaseDataStoreAdd
extends AbstractAddStepHandler {
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String jndiName = DatabaseDataStoreResourceDefinition.DATASOURCE_JNDI_NAME.resolveModelAttribute(context, model).asString();
        ModelNode dataBaseValue = DatabaseDataStoreResourceDefinition.DATABASE.resolveModelAttribute(context, model);
        String database = dataBaseValue.isDefined() ? dataBaseValue.asString() : null;
        String partition = DatabaseDataStoreResourceDefinition.PARTITION.resolveModelAttribute(context, model).asString();
        int refreshInterval = DatabaseDataStoreResourceDefinition.REFRESH_INTERVAL.resolveModelAttribute(context, model).asInt();
        boolean allowExecution = DatabaseDataStoreResourceDefinition.ALLOW_EXECUTION.resolveModelAttribute(context, model).asBoolean();
        String nodeName = WildFlySecurityManager.getPropertyPrivileged((String)"jboss.node.name", null);
        CapabilityServiceTarget serviceTarget = context.getCapabilityServiceTarget();
        CapabilityServiceBuilder builder = serviceTarget.addCapability(TimerPersistenceResourceDefinition.CAPABILITY);
        Consumer consumer = builder.provides(TimerPersistenceResourceDefinition.CAPABILITY);
        Supplier dataSourceSupplier = builder.requires(ContextNames.bindInfoFor((String)jndiName).getBinderServiceName());
        Supplier moduleLoaderSupplier = builder.requires(Services.JBOSS_SERVICE_MODULE_LOADER);
        Supplier timerSupplier = builder.requires(TimerServiceResourceDefinition.TIMER_SERVICE_DESCRIPTOR);
        DatabaseTimerPersistence databaseTimerPersistence = new DatabaseTimerPersistence(consumer, dataSourceSupplier, moduleLoaderSupplier, timerSupplier, database, partition, nodeName, refreshInterval, allowExecution);
        builder.setInstance((Service)databaseTimerPersistence);
        builder.install();
    }
}

