/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import jakarta.ejb.EJBException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.io.ObjectStreamException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ejb3.component.InvokeMethodOnTargetInterceptor;
import org.jboss.as.ejb3.component.session.SessionBeanComponentInstance;
import org.jboss.as.ejb3.component.stateful.CurrentSynchronizationCallback;
import org.jboss.as.ejb3.component.stateful.SerializedStatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanInstance;
import org.jboss.as.ejb3.tx.OwnableReentrantLock;
import org.jboss.as.naming.ManagedReference;
import org.jboss.ejb.client.SessionID;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.wildfly.transaction.client.AbstractTransaction;
import org.wildfly.transaction.client.ContextTransactionManager;

public class StatefulSessionComponentInstance
extends SessionBeanComponentInstance
implements StatefulSessionBeanInstance<SessionID> {
    private static final long serialVersionUID = 3803978357389448971L;
    private final SessionID id;
    private final Interceptor afterBegin;
    private final Interceptor afterCompletion;
    private final Interceptor beforeCompletion;
    private final Interceptor prePassivate;
    private final Interceptor postActivate;
    private final Interceptor ejb2XRemoveInterceptor;
    private volatile Transaction transaction;
    private final OwnableReentrantLock lock = new OwnableReentrantLock();
    private final Object threadLock = new Object();
    private final AtomicInteger invocationSyncState = new AtomicInteger();
    public static final int SYNC_STATE_NO_INVOCATION = 0;
    public static final int SYNC_STATE_INVOCATION_IN_PROGRESS = 1;
    public static final int SYNC_STATE_AFTER_COMPLETE_DELAYED_NO_COMMIT = 2;
    public static final int SYNC_STATE_AFTER_COMPLETE_DELAYED_COMMITTED = 3;

    Object getThreadLock() {
        return this.threadLock;
    }

    OwnableReentrantLock getLock() {
        return this.lock;
    }

    AtomicInteger getInvocationSyncState() {
        return this.invocationSyncState;
    }

    protected StatefulSessionComponentInstance(StatefulSessionComponent component, Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors, Map<Object, Object> context) {
        super(component, preDestroyInterceptor, methodInterceptors);
        SessionID existingSession = (SessionID)context.get(SessionID.class);
        this.id = existingSession != null ? existingSession : component.getCache().getIdentifierFactory().get();
        this.afterBegin = component.getAfterBegin();
        this.afterCompletion = component.getAfterCompletion();
        this.beforeCompletion = component.getBeforeCompletion();
        this.prePassivate = component.getPrePassivate();
        this.postActivate = component.getPostActivate();
        this.ejb2XRemoveInterceptor = component.getEjb2XRemoveMethod();
    }

    protected void afterBegin() {
        CurrentSynchronizationCallback.set(CurrentSynchronizationCallback.CallbackType.AFTER_BEGIN);
        try {
            this.execute(this.afterBegin, this.getComponent().getAfterBeginMethod(), new Object[0]);
        }
        finally {
            CurrentSynchronizationCallback.clear();
        }
    }

    protected void afterCompletion(boolean committed) {
        CurrentSynchronizationCallback.set(CurrentSynchronizationCallback.CallbackType.AFTER_COMPLETION);
        try {
            this.execute(this.afterCompletion, this.getComponent().getAfterCompletionMethod(), committed);
        }
        finally {
            CurrentSynchronizationCallback.clear();
        }
    }

    protected void beforeCompletion() {
        CurrentSynchronizationCallback.set(CurrentSynchronizationCallback.CallbackType.BEFORE_COMPLETION);
        try {
            this.execute(this.beforeCompletion, this.getComponent().getBeforeCompletionMethod(), new Object[0]);
        }
        finally {
            CurrentSynchronizationCallback.clear();
        }
    }

    public void prePassivate() {
        this.execute(this.prePassivate, null, new Object[0]);
    }

    public void postActivate() {
        this.execute(this.postActivate, null, new Object[0]);
    }

    private Object execute(Interceptor interceptor, Method method, Object ... parameters) {
        if (interceptor == null) {
            return null;
        }
        InterceptorContext interceptorContext = new InterceptorContext();
        interceptorContext.setMethod(method);
        interceptorContext.putPrivateData(Component.class, (Object)this.getComponent());
        interceptorContext.putPrivateData(ComponentInstance.class, (Object)this);
        interceptorContext.putPrivateData(InvokeMethodOnTargetInterceptor.PARAMETERS_KEY, (Object)parameters);
        interceptorContext.setContextData(new HashMap());
        interceptorContext.setTarget(this.getInstance());
        AbstractTransaction transaction = ContextTransactionManager.getInstance().getTransaction();
        interceptorContext.setTransactionSupplier(() -> transaction);
        try {
            return interceptor.processInvocation(interceptorContext);
        }
        catch (Error e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    @Override
    public StatefulSessionComponent getComponent() {
        return (StatefulSessionComponent)super.getComponent();
    }

    @Override
    public SessionID getId() {
        return this.id;
    }

    public Interceptor getEjb2XRemoveInterceptor() {
        return this.ejb2XRemoveInterceptor;
    }

    public String toString() {
        return " Instance of " + this.getComponent().getComponentName() + " {" + String.valueOf(this.id) + "}";
    }

    public Object writeReplace() throws ObjectStreamException {
        Set<Object> keys = this.getComponent().getSerialiableInterceptorContextKeys();
        HashMap<Object, Object> serializableInterceptors = new HashMap<Object, Object>();
        for (Object key : keys) {
            serializableInterceptors.put(key, this.getInstanceData(key));
        }
        return new SerializedStatefulSessionComponent((ManagedReference)this.getInstanceData(INSTANCE_KEY), this.id, this.getComponent().getCreateServiceName().getCanonicalName(), serializableInterceptors);
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    @Override
    public void removed() {
        TransactionSynchronizationRegistry tsr = this.getComponent().getTransactionSynchronizationRegistry();
        if (tsr.getTransactionKey() == null || tsr.getResource((Object)this.id) == null) {
            this.destroy();
        }
    }
}

