/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import jakarta.ejb.EJBException;
import jakarta.ejb.ScheduleExpression;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerConfig;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.CompletionStage;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimer;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerService;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.as.server.suspend.ServerResumeContext;
import org.jboss.as.server.suspend.ServerSuspendContext;
import org.jboss.as.server.suspend.SuspendableActivity;
import org.jboss.as.server.suspend.SuspendableActivityRegistry;
import org.jboss.as.server.suspend.SuspensionStateProvider;

public class SuspendableTimerService
implements ManagedTimerService {
    private final ManagedTimerService service;
    private final SuspendableActivityRegistry registry;
    private final SuspendableActivity activity;

    public SuspendableTimerService(final ManagedTimerService service, SuspendableActivityRegistry registry) {
        this.service = service;
        this.registry = registry;
        this.activity = new SuspendableActivity(){

            public CompletionStage<Void> suspend(ServerSuspendContext context) {
                if (!context.isStarting()) {
                    EjbLogger.EJB3_TIMER_LOGGER.debugf("Suspending timer service for %s", service.getInvoker());
                    service.stop();
                }
                return SuspendableActivity.COMPLETED;
            }

            public CompletionStage<Void> resume(ServerResumeContext context) {
                EjbLogger.EJB3_TIMER_LOGGER.debugf("Resuming timer service for %s", service.getInvoker());
                service.start();
                return SuspendableActivity.COMPLETED;
            }
        };
    }

    public boolean isStarted() {
        return this.service.isStarted();
    }

    public void start() {
        this.registry.registerActivity(this.activity);
        if (this.registry.getState() == SuspensionStateProvider.State.RUNNING) {
            this.service.start();
        }
    }

    public void stop() {
        if (this.registry.getState() == SuspensionStateProvider.State.RUNNING) {
            this.service.stop();
        }
        this.registry.unregisterActivity(this.activity);
    }

    @Override
    public void close() {
        this.service.close();
    }

    public Collection<Timer> getTimers() throws EJBException {
        return this.service.getTimers();
    }

    public Collection<Timer> getAllTimers() throws EJBException {
        return this.service.getAllTimers();
    }

    public Timer createSingleActionTimer(Date expiration, TimerConfig timerConfig) throws EJBException {
        return this.service.createSingleActionTimer(expiration, timerConfig);
    }

    public Timer createIntervalTimer(Date initialExpiration, long intervalDuration, TimerConfig timerConfig) throws EJBException {
        return this.service.createIntervalTimer(initialExpiration, intervalDuration, timerConfig);
    }

    public Timer createCalendarTimer(ScheduleExpression schedule, TimerConfig timerConfig) throws EJBException {
        return this.service.createCalendarTimer(schedule, timerConfig);
    }

    @Override
    public ManagedTimer findTimer(String id) {
        return this.service.findTimer(id);
    }

    @Override
    public TimedObjectInvoker getInvoker() {
        return this.service.getInvoker();
    }
}

