/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.ejb3.subsystem.EJB3Subsystem12Parser;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemNamespace;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLAttribute;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLElement;
import org.jboss.as.ejb3.subsystem.FileDataStoreResourceDefinition;
import org.jboss.as.ejb3.subsystem.StrictMaxPoolResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class EJB3Subsystem11Parser
implements XMLElementReader<List<ModelNode>> {
    EJB3Subsystem11Parser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode ejb3SubsystemAddOperation = new ModelNode();
        ejb3SubsystemAddOperation.get("operation").set("add");
        ejb3SubsystemAddOperation.get("address").add("subsystem", "ejb3");
        operations.add(ejb3SubsystemAddOperation);
        EnumSet<EJB3SubsystemXMLElement> encountered = EnumSet.noneOf(EJB3SubsystemXMLElement.class);
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemNamespace.forUri(reader.getNamespaceURI())) {
                case EJB3_1_1: {
                    EJB3SubsystemXMLElement element = EJB3SubsystemXMLElement.forName(reader.getLocalName());
                    if (!encountered.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (element) {
                        case MDB: {
                            this.parseMDB(reader, operations, ejb3SubsystemAddOperation);
                            continue block9;
                        }
                        case POOLS: {
                            this.parsePools(reader, operations);
                            continue block9;
                        }
                        case SESSION_BEAN: {
                            this.parseSessionBean(reader, operations, ejb3SubsystemAddOperation);
                            continue block9;
                        }
                        case TIMER_SERVICE: {
                            this.parseTimerService(reader, operations);
                            continue block9;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private ModelNode parseMDB(XMLExtendedStreamReader reader, List<ModelNode> operations, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        ModelNode defaultRAName;
        ModelNode mdbModelNode = new ModelNode();
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case BEAN_INSTANCE_POOL_REF: {
                    String poolName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)EJB3SubsystemXMLAttribute.POOL_NAME.getLocalName());
                    EJB3SubsystemRootResourceDefinition.DEFAULT_MDB_INSTANCE_POOL.parseAndSetParameter(poolName, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
                    continue block4;
                }
                case RESOURCE_ADAPTER_REF: {
                    String resourceAdapterName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)EJB3SubsystemXMLAttribute.RESOURCE_ADAPTER_NAME.getLocalName());
                    EJB3SubsystemRootResourceDefinition.DEFAULT_RESOURCE_ADAPTER_NAME.parseAndSetParameter(resourceAdapterName, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!ejb3SubsystemAddOperation.hasDefined("default-resource-adapter-name") && (defaultRAName = EJB3SubsystemRootResourceDefinition.DEFAULT_RESOURCE_ADAPTER_NAME.getDefaultValue()) != null) {
            ejb3SubsystemAddOperation.get("default-resource-adapter-name").set(defaultRAName);
        }
        return mdbModelNode;
    }

    private void parseSessionBean(XMLExtendedStreamReader reader, List<ModelNode> operations, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case STATELESS: {
                    this.parseStatelessBean(reader, operations, ejb3SubsystemAddOperation);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseStatelessBean(XMLExtendedStreamReader reader, List<ModelNode> operations, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case BEAN_INSTANCE_POOL_REF: {
                    String poolName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)EJB3SubsystemXMLAttribute.POOL_NAME.getLocalName());
                    EJB3SubsystemRootResourceDefinition.DEFAULT_SLSB_INSTANCE_POOL.parseAndSetParameter(poolName, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parsePools(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case BEAN_INSTANCE_POOLS: {
                    this.parseBeanInstancePools(reader, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseBeanInstancePools(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case STRICT_MAX_POOL: {
                    this.parseStrictMaxPool(reader, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected void parseStrictMaxPool(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String poolName = null;
        Integer maxPoolSize = null;
        Long timeout = null;
        String unit = null;
        block6: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    poolName = value;
                    continue block6;
                }
                case MAX_POOL_SIZE: {
                    maxPoolSize = EJB3Subsystem11Parser.parse((AttributeDefinition)StrictMaxPoolResourceDefinition.MAX_POOL_SIZE, value, (XMLStreamReader)reader).asInt();
                    continue block6;
                }
                case INSTANCE_ACQUISITION_TIMEOUT: {
                    timeout = EJB3Subsystem11Parser.parse((AttributeDefinition)StrictMaxPoolResourceDefinition.INSTANCE_ACQUISITION_TIMEOUT, value, (XMLStreamReader)reader).asLong();
                    continue block6;
                }
                case INSTANCE_ACQUISITION_TIMEOUT_UNIT: {
                    unit = EJB3Subsystem11Parser.parse((AttributeDefinition)StrictMaxPoolResourceDefinition.INSTANCE_ACQUISITION_TIMEOUT_UNIT, value, (XMLStreamReader)reader).asString();
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (poolName == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(EJB3SubsystemXMLAttribute.NAME.getLocalName()));
        }
        operations.add(this.createAddStrictMaxBeanInstancePoolOperation(poolName, maxPoolSize, timeout, unit));
    }

    private void parseTimerService(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode address = new ModelNode();
        address.add("subsystem", "ejb3");
        address.add("service", "timer-service");
        ModelNode timerServiceAdd = new ModelNode();
        timerServiceAdd.get("operation").set("add");
        timerServiceAdd.get("address").set(address);
        String dataStorePath = null;
        String dataStorePathRelativeTo = null;
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case THREAD_POOL: {
                    int i;
                    int count = reader.getAttributeCount();
                    block13: for (i = 0; i < count; ++i) {
                        ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                        EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case CORE_THREADS: {
                                continue block13;
                            }
                            case MAX_THREADS: {
                                continue block13;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block12;
                }
                case DATA_STORE: {
                    int i;
                    int count = reader.getAttributeCount();
                    block14: for (i = 0; i < count; ++i) {
                        ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                        String value = reader.getAttributeValue(i);
                        EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case PATH: {
                                if (dataStorePath != null) {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                                dataStorePath = EJB3Subsystem11Parser.parse((AttributeDefinition)FileDataStoreResourceDefinition.PATH, value, (XMLStreamReader)reader).asString();
                                continue block14;
                            }
                            case RELATIVE_TO: {
                                if (dataStorePathRelativeTo != null) {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                                dataStorePathRelativeTo = EJB3Subsystem11Parser.parse((AttributeDefinition)FileDataStoreResourceDefinition.RELATIVE_TO, value, (XMLStreamReader)reader).asString();
                                continue block14;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    if (dataStorePath == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(EJB3SubsystemXMLAttribute.PATH));
                    }
                    timerServiceAdd.get("default-data-store").set("default-file-store");
                    ModelNode fileDataStoreAdd = new ModelNode();
                    ModelNode fileDataAddress = address.clone();
                    fileDataAddress.add("file-data-store", "default-file-store");
                    fileDataStoreAdd.get("operation").set("add");
                    fileDataStoreAdd.get("address").set(fileDataAddress);
                    fileDataStoreAdd.get("path").set(dataStorePath);
                    if (dataStorePathRelativeTo != null) {
                        fileDataStoreAdd.get("relative-to").set(dataStorePathRelativeTo);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(timerServiceAdd);
    }

    private ModelNode createAddStrictMaxBeanInstancePoolOperation(String name, Integer maxPoolSize, Long timeout, String timeoutUnit) {
        ModelNode addStrictMaxPoolOperation = new ModelNode();
        addStrictMaxPoolOperation.get("operation").set("add");
        PathAddress address = this.getEJB3SubsystemAddress().append(new PathElement[]{PathElement.pathElement((String)"strict-max-bean-instance-pool", (String)name)});
        addStrictMaxPoolOperation.get("address").set(address.toModelNode());
        if (maxPoolSize != null) {
            addStrictMaxPoolOperation.get("max-pool-size").set(maxPoolSize.intValue());
        }
        if (timeout != null) {
            addStrictMaxPoolOperation.get("timeout").set(timeout.longValue());
        }
        if (timeoutUnit != null) {
            addStrictMaxPoolOperation.get("timeout-unit").set(timeoutUnit);
        }
        return addStrictMaxPoolOperation;
    }

    private PathAddress getEJB3SubsystemAddress() {
        return EJB3Subsystem12Parser.SUBSYSTEM_PATH;
    }

    private static ModelNode parse(AttributeDefinition ad, String value, XMLStreamReader reader) throws XMLStreamException {
        return ad.getParser().parse(ad, value, reader);
    }
}

