/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.schedule.value;

import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.schedule.value.RangeValue;

public enum ScheduleExpressionType {
    SINGLE_VALUE,
    WILDCARD,
    LIST,
    RANGE,
    INCREMENT;


    public static ScheduleExpressionType getType(String value) {
        if (value == null) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidScheduleValue("", value);
        }
        if (value.trim().equals("*")) {
            return WILDCARD;
        }
        if (value.contains(",")) {
            return LIST;
        }
        if (value.contains("-") && RangeValue.accepts(value)) {
            return RANGE;
        }
        if (value.contains("/")) {
            return INCREMENT;
        }
        return SINGLE_VALUE;
    }
}

