/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import jakarta.annotation.security.DeclareRoles;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;

public class DeclareRolesMergingProcessor
extends AbstractMergingProcessor<EJBComponentDescription> {
    public DeclareRolesMergingProcessor() {
        super(EJBComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription description) throws DeploymentUnitProcessingException {
        EEModuleClassDescription clazz = applicationClasses.getClassByName(componentClass.getName());
        if (clazz == null) {
            return;
        }
        ClassAnnotationInformation declareRoles = clazz.getAnnotationInformation(DeclareRoles.class);
        if (declareRoles == null) {
            return;
        }
        if (!declareRoles.getClassLevelAnnotations().isEmpty()) {
            description.addDeclaredRoles((String[])declareRoles.getClassLevelAnnotations().get(0));
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription description) throws DeploymentUnitProcessingException {
        if (description.getDescriptorData() == null) {
            return;
        }
        SecurityRoleRefsMetaData roleRefs = description.getDescriptorData().getSecurityRoleRefs();
        if (roleRefs != null) {
            for (SecurityRoleRefMetaData ref : roleRefs) {
                description.addDeclaredRoles(ref.getRoleName());
            }
        }
    }
}

