/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.jboss.as.ejb3.timerservice.CalendarTimer;
import org.jboss.as.ejb3.timerservice.TimerImpl;
import org.jboss.as.ejb3.timerservice.TimerState;
import org.jboss.as.ejb3.timerservice.TimerTask;
import org.jboss.as.ejb3.timerservice.schedule.CalendarBasedTimeout;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;

public class CalendarTimerTask
extends TimerTask {
    public CalendarTimerTask(CalendarTimer calendarTimer) {
        super(calendarTimer);
    }

    @Override
    protected void callTimeout(TimerImpl timer) throws Exception {
        if (timer.getNextExpiration() != null && !timer.isInRetry()) {
            timer.scheduleTimeout(false);
        }
        this.invokeBeanMethod(timer);
    }

    @Override
    protected void invokeBeanMethod(TimerImpl timer) throws Exception {
        if (timer.isAutoTimer()) {
            CalendarTimer calendarTimer = (CalendarTimer)timer;
            TimedObjectInvoker invoker = this.timerService.getInvoker();
            invoker.callTimeout(calendarTimer, calendarTimer.getTimeoutMethod());
        } else {
            this.timerService.getInvoker().callTimeout(timer);
        }
    }

    @Override
    protected Date calculateNextTimeout(TimerImpl timer) {
        Date currentTimeout = timer.getNextExpiration();
        if (currentTimeout == null) {
            return null;
        }
        Calendar nextTimeout = new GregorianCalendar();
        nextTimeout.setTime(currentTimeout);
        CalendarBasedTimeout timeout = ((CalendarTimer)timer).getCalendarTimeout();
        Date now = new Date();
        while ((nextTimeout = timeout.getNextTimeout(nextTimeout)) != null && nextTimeout.getTime().before(now)) {
        }
        return nextTimeout != null ? nextTimeout.getTime() : null;
    }

    @Override
    protected void scheduleTimeoutIfRequired(TimerImpl timer) {
        if (timer.getNextExpiration() != null) {
            timer.scheduleTimeout(false);
        }
    }

    @Override
    protected void postTimeoutProcessing(TimerImpl timer) throws InterruptedException {
        timer.lock();
        try {
            TimerState timerState = timer.getState();
            if (timerState != TimerState.CANCELED && timerState != TimerState.EXPIRED) {
                if (timer.getNextExpiration() == null) {
                    this.timerService.expireTimer(timer);
                } else {
                    timer.setTimerState(TimerState.ACTIVE, null);
                    this.timerService.persistTimer(timer, false);
                }
            }
        }
        finally {
            timer.unlock();
        }
    }
}

