/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.composite;

import jakarta.ejb.TimerConfig;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.timerservice.composite.CompositeTimerService;
import org.jboss.as.ejb3.timerservice.composite.CompositeTimerServiceConfiguration;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerService;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerServiceConfiguration;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerServiceFactory;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerServiceFactoryConfiguration;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvokerFactory;
import org.jboss.as.ejb3.timerservice.spi.TimerListener;
import org.jboss.as.ejb3.timerservice.spi.TimerServiceRegistry;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.msc.service.ServiceName;
import org.wildfly.common.function.Functions;
import org.wildfly.subsystem.service.DeploymentServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class CompositeTimerServiceFactoryServiceInstaller
implements DeploymentServiceInstaller {
    private final ServiceName name;
    private final ManagedTimerServiceFactoryConfiguration configuration;

    public CompositeTimerServiceFactoryServiceInstaller(ServiceName name, ManagedTimerServiceFactoryConfiguration configuration) {
        this.name = name;
        this.configuration = configuration;
    }

    public void install(DeploymentPhaseContext context) {
        final TimedObjectInvokerFactory invokerFactory = this.configuration.getInvokerFactory();
        final TimerServiceRegistry registry = this.configuration.getTimerServiceRegistry();
        final ServiceDependency transientFactory = ServiceDependency.on((ServiceName)ManagedTimerServiceConfiguration.TimerFilter.TRANSIENT.apply(this.name));
        final ServiceDependency persistentFactory = ServiceDependency.on((ServiceName)ManagedTimerServiceConfiguration.TimerFilter.PERSISTENT.apply(this.name));
        ManagedTimerServiceFactory factory = new ManagedTimerServiceFactory(){

            @Override
            public ManagedTimerService createTimerService(EJBComponent component) {
                final TimedObjectInvoker invoker = invokerFactory.createInvoker(component);
                final ManagedTimerService transientTimerService = ((ManagedTimerServiceFactory)transientFactory.get()).createTimerService(component);
                final ManagedTimerService persistentTimerService = ((ManagedTimerServiceFactory)persistentFactory.get()).createTimerService(component);
                return new CompositeTimerService(new CompositeTimerServiceConfiguration(){

                    @Override
                    public TimedObjectInvoker getInvoker() {
                        return invoker;
                    }

                    @Override
                    public TimerServiceRegistry getTimerServiceRegistry() {
                        return registry;
                    }

                    @Override
                    public TimerListener getTimerListener() {
                        return null;
                    }

                    @Override
                    public ManagedTimerService getTransientTimerService() {
                        return transientTimerService;
                    }

                    @Override
                    public ManagedTimerService getPersistentTimerService() {
                        return persistentTimerService;
                    }

                    @Override
                    public Predicate<TimerConfig> getTimerFilter() {
                        return ManagedTimerServiceConfiguration.TimerFilter.ALL;
                    }
                });
            }
        };
        ((ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)Functions.constantSupplier((Object)factory)).provides(this.name)).requires(List.of(transientFactory, persistentFactory))).build()).install(context);
    }
}

