/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ejb3.security.ApplicationSecurityDomainConfig;
import org.jboss.as.ejb3.subsystem.ApplicationSecurityDomainService;
import org.jboss.as.ejb3.subsystem.EJB3Extension;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.security.auth.server.SecurityDomain;

public class ApplicationSecurityDomainDefinition
extends SimpleResourceDefinition {
    public static final String APPLICATION_SECURITY_DOMAIN_CAPABILITY_NAME = "org.wildfly.ejb3.application-security-domain";
    public static final String CAPABILITY_APPLICATION_SECURITY_DOMAIN_KNOWN_DEPLOYMENTS = "org.wildfly.ejb3.application-security-domain.known-deployments";
    private static final String SECURITY_DOMAIN_CAPABILITY_NAME = "org.wildfly.security.security-domain";
    static final RuntimeCapability<Void> APPLICATION_SECURITY_DOMAIN_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.ejb3.application-security-domain", (boolean)true, ApplicationSecurityDomainService.ApplicationSecurityDomain.class).build();
    static final SimpleAttributeDefinition SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-domain", ModelType.STRING, false).setValidator((ParameterValidator)new StringLengthValidator(1))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setCapabilityReference("org.wildfly.security.security-domain", APPLICATION_SECURITY_DOMAIN_CAPABILITY)).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.ELYTRON_SECURITY_DOMAIN_REF})).build();
    private static final StringListAttributeDefinition REFERENCING_DEPLOYMENTS = ((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("referencing-deployments").setStorageRuntime()).build();
    static final SimpleAttributeDefinition ENABLE_JACC = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enable-jacc", ModelType.BOOLEAN, true).setDefaultValue(ModelNode.FALSE)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition LEGACY_COMPLIANT_PRINCIPAL_PROPAGATION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("legacy-compliant-principal-propagation", ModelType.BOOLEAN, true).setDefaultValue(ModelNode.TRUE)).setRestartAllServices()).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{SECURITY_DOMAIN, ENABLE_JACC, LEGACY_COMPLIANT_PRINCIPAL_PROPAGATION};
    private static final OperationContext.AttachmentKey<KnownDeploymentsApi> KNOWN_DEPLOYMENTS_KEY = OperationContext.AttachmentKey.create(KnownDeploymentsApi.class);

    ApplicationSecurityDomainDefinition(Set<ApplicationSecurityDomainConfig> knownApplicationSecurityDomains) {
        this((SimpleResourceDefinition.Parameters)new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"application-security-domain"), EJB3Extension.getResourceDescriptionResolver("application-security-domain")).setCapabilities(new RuntimeCapability[]{APPLICATION_SECURITY_DOMAIN_CAPABILITY}).addAccessConstraints(new AccessConstraintDefinition[]{new SensitiveTargetAccessConstraintDefinition(new SensitivityClassification("ejb3", "application-security-domain", false, false, false)), new ApplicationTypeAccessConstraintDefinition(new ApplicationTypeConfig("ejb3", "application-security-domain"))}), new AddHandler(knownApplicationSecurityDomains));
    }

    private ApplicationSecurityDomainDefinition(SimpleResourceDefinition.Parameters parameters, AddHandler add) {
        super(parameters.setAddHandler((OperationStepHandler)add).setRemoveHandler((OperationStepHandler)new RemoveHandler(add)));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ReloadRequiredWriteAttributeHandler handler = new ReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attribute : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)handler);
        }
        if (resourceRegistration.getProcessType().isServer()) {
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)REFERENCING_DEPLOYMENTS, (OperationStepHandler)new ReferencingDeploymentsHandler());
        }
    }

    private static class AddHandler
    extends AbstractAddStepHandler {
        private final Set<ApplicationSecurityDomainConfig> knownApplicationSecurityDomains;

        private AddHandler(Set<ApplicationSecurityDomainConfig> knownApplicationSecurityDomains) {
            super(ATTRIBUTES);
            this.knownApplicationSecurityDomains = knownApplicationSecurityDomains;
        }

        protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.recordCapabilitiesAndRequirements(context, operation, resource);
            KnownDeploymentsApi knownDeployments = new KnownDeploymentsApi();
            context.registerCapability(RuntimeCapability.Builder.of((String)ApplicationSecurityDomainDefinition.CAPABILITY_APPLICATION_SECURITY_DOMAIN_KNOWN_DEPLOYMENTS, (boolean)true, (Object)knownDeployments).build().fromBaseCapability(context.getCurrentAddressValue()));
            context.attach(KNOWN_DEPLOYMENTS_KEY, (Object)knownDeployments);
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.populateModel(context, operation, resource);
            ModelNode model = resource.getModel();
            boolean enableJacc = false;
            boolean legacyCompliantPrincipalPropagation = true;
            if (model.hasDefined(ENABLE_JACC.getName())) {
                enableJacc = ENABLE_JACC.resolveModelAttribute(context, model).asBoolean();
            }
            if (model.hasDefined(LEGACY_COMPLIANT_PRINCIPAL_PROPAGATION.getName())) {
                legacyCompliantPrincipalPropagation = LEGACY_COMPLIANT_PRINCIPAL_PROPAGATION.resolveModelAttribute(context, model).asBoolean();
            }
            this.knownApplicationSecurityDomains.add(new ApplicationSecurityDomainConfig(context.getCurrentAddressValue(), enableJacc, legacyCompliantPrincipalPropagation));
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            String securityDomain = SECURITY_DOMAIN.resolveModelAttribute(context, model).asString();
            boolean enableJacc = ENABLE_JACC.resolveModelAttribute(context, model).asBoolean();
            boolean legacyCompliantPrincipalPropagation = LEGACY_COMPLIANT_PRINCIPAL_PROPAGATION.resolveModelAttribute(context, model).asBoolean();
            RuntimeCapability runtimeCapability = APPLICATION_SECURITY_DOMAIN_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName serviceName = runtimeCapability.getCapabilityServiceName(ApplicationSecurityDomainService.ApplicationSecurityDomain.class);
            ServiceName securityDomainServiceName = serviceName.append(new String[]{"security-domain"});
            CapabilityServiceBuilder serviceBuilder = context.getCapabilityServiceTarget().addCapability(APPLICATION_SECURITY_DOMAIN_CAPABILITY).setInitialMode(ServiceController.Mode.LAZY);
            Supplier securityDomainSupplier = serviceBuilder.requires(context.getCapabilityServiceName(ApplicationSecurityDomainDefinition.SECURITY_DOMAIN_CAPABILITY_NAME, securityDomain, SecurityDomain.class));
            Consumer applicationSecurityDomainConsumer = serviceBuilder.provides(new ServiceName[]{serviceName});
            Consumer securityDomainConsumer = serviceBuilder.provides(new ServiceName[]{securityDomainServiceName});
            ApplicationSecurityDomainService service = new ApplicationSecurityDomainService(enableJacc, securityDomainSupplier, applicationSecurityDomainConsumer, securityDomainConsumer);
            serviceBuilder.setInstance((Service)service);
            serviceBuilder.install();
            KnownDeploymentsApi knownDeploymentsApi = (KnownDeploymentsApi)context.getAttachment(KNOWN_DEPLOYMENTS_KEY);
            knownDeploymentsApi.setApplicationSecurityDomainService(service);
        }
    }

    private static class RemoveHandler
    extends ServiceRemoveStepHandler {
        private final Set<ApplicationSecurityDomainConfig> knownApplicationSecurityDomains;

        protected RemoveHandler(AddHandler addOperation) {
            super((AbstractAddStepHandler)addOperation);
            this.knownApplicationSecurityDomains = addOperation.knownApplicationSecurityDomains;
        }

        protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performRemove(context, operation, model);
            String name = context.getCurrentAddressValue();
            this.knownApplicationSecurityDomains.removeIf(domain -> domain.isSameDomain(name));
        }

        protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.recordCapabilitiesAndRequirements(context, operation, resource);
            context.deregisterCapability(RuntimeCapability.buildDynamicCapabilityName((String)ApplicationSecurityDomainDefinition.CAPABILITY_APPLICATION_SECURITY_DOMAIN_KNOWN_DEPLOYMENTS, (String)context.getCurrentAddressValue()));
        }

        protected ServiceName serviceName(String name) {
            return APPLICATION_SECURITY_DOMAIN_CAPABILITY.getCapabilityServiceName(ApplicationSecurityDomainService.ApplicationSecurityDomain.class, new String[]{name});
        }
    }

    private static class ReferencingDeploymentsHandler
    implements OperationStepHandler {
        private ReferencingDeploymentsHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.isDefaultRequiresRuntime()) {
                context.addStep((ctx, op) -> {
                    KnownDeploymentsApi knownDeploymentsApi = (KnownDeploymentsApi)context.getCapabilityRuntimeAPI(ApplicationSecurityDomainDefinition.CAPABILITY_APPLICATION_SECURITY_DOMAIN_KNOWN_DEPLOYMENTS, ctx.getCurrentAddressValue(), KnownDeploymentsApi.class);
                    ModelNode deploymentList = new ModelNode();
                    for (String current : knownDeploymentsApi.getKnownDeployments()) {
                        deploymentList.add(current);
                    }
                    context.getResult().set(deploymentList);
                }, OperationContext.Stage.RUNTIME);
            }
        }
    }

    private static class KnownDeploymentsApi {
        private volatile ApplicationSecurityDomainService service;

        private KnownDeploymentsApi() {
        }

        List<String> getKnownDeployments() {
            return this.service != null ? Arrays.asList(this.service.getDeployments()) : Collections.emptyList();
        }

        void setApplicationSecurityDomainService(ApplicationSecurityDomainService service) {
            this.service = service;
        }
    }
}

