/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.util.Headers;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Deque;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.core.security.AccessMechanism;
import org.jboss.as.domain.http.server.Common;
import org.jboss.as.domain.http.server.DomainUtil;
import org.jboss.as.domain.http.server.HttpServerLogger;
import org.jboss.as.domain.http.server.OperationParameter;
import org.jboss.dmr.ModelNode;

class DomainApiGenericOperationHandler
implements HttpHandler {
    private static final String OPERATION = "operation";
    private static final String INPUT_STREAMS = "input-streams";
    private final ModelController modelController;
    private final FormParserFactory formParserFactory;
    static final String RELOAD = "reload";

    public DomainApiGenericOperationHandler(ModelController modelController) {
        this.modelController = modelController;
        this.formParserFactory = FormParserFactory.builder().build();
    }

    public void handleRequest(final HttpServerExchange exchange) throws Exception {
        ModelNode response;
        ModelNode operation;
        FormDataParser parser = this.formParserFactory.createParser(exchange);
        if (parser == null) {
            Common.UNSUPPORTED_MEDIA_TYPE.handleRequest(exchange);
            return;
        }
        FormData data = parser.parseBlocking();
        OperationParameter.Builder operationParameterBuilder = new OperationParameter.Builder(false);
        FormData.FormValue op = data.getFirst(OPERATION);
        try {
            if ("application/dmr-encoded".equals(op.getHeaders().getFirst(Headers.CONTENT_TYPE))) {
                operation = ModelNode.fromBase64((InputStream)new ByteArrayInputStream(op.getValue().getBytes()));
                operationParameterBuilder.encode(true);
            } else {
                operation = ModelNode.fromJSONString((String)op.getValue());
            }
        }
        catch (Exception e) {
            HttpServerLogger.ROOT_LOGGER.errorf("Unable to construct ModelNode '%s'", e.getMessage());
            Common.sendError(exchange, false, e.getLocalizedMessage());
            return;
        }
        OperationBuilder builder = OperationBuilder.create((ModelNode)operation, (boolean)true);
        Deque contents = data.get(INPUT_STREAMS);
        if (contents != null && !contents.isEmpty()) {
            for (FormData.FormValue value : contents) {
                builder.addFileAsAttachment(value.getFile());
            }
        }
        operationParameterBuilder.pretty(operation.hasDefined("json.pretty") && operation.get("json.pretty").asBoolean());
        final OperationParameter opParam = operationParameterBuilder.build();
        final ResponseCallback callback = new ResponseCallback(){

            @Override
            void doSendResponse(ModelNode response) {
                if (response.hasDefined("outcome") && "failed".equals(response.get("outcome").asString())) {
                    Common.sendError(exchange, opParam.isEncode(), response);
                    return;
                }
                DomainUtil.writeResponse(exchange, 200, response, opParam);
            }
        };
        boolean sendPreparedResponse = this.sendPreparedResponse(operation);
        ModelController.OperationTransactionControl control = sendPreparedResponse ? new ModelController.OperationTransactionControl(){

            public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                transaction.commit();
                result.get("outcome").set("success");
                result.get("result");
                callback.sendResponse(result);
            }
        } : ModelController.OperationTransactionControl.COMMIT;
        try {
            operation.get(new String[]{"operation-headers", "access-mechanism"}).set(AccessMechanism.HTTP.toString());
            response = this.modelController.execute(operation, OperationMessageHandler.DISCARD, control, (OperationAttachments)builder.build());
        }
        catch (Throwable t) {
            HttpServerLogger.ROOT_LOGGER.modelRequestError(t);
            Common.sendError(exchange, opParam.isEncode(), t.getLocalizedMessage());
            return;
        }
        callback.sendResponse(response);
    }

    private boolean sendPreparedResponse(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String op = operation.get(OPERATION).asString();
        int size = address.size();
        if (size == 0) {
            if (op.equals(RELOAD)) {
                return true;
            }
            if (op.equals("composite")) {
                return false;
            }
            return false;
        }
        if (size == 1 && address.getLastElement().getKey().equals("host")) {
            return op.equals(RELOAD);
        }
        return false;
    }

    private static abstract class ResponseCallback {
        private boolean complete;

        private ResponseCallback() {
        }

        synchronized void sendResponse(ModelNode response) {
            if (this.complete) {
                return;
            }
            this.complete = true;
            this.doSendResponse(response);
        }

        abstract void doSendResponse(ModelNode var1);
    }
}

