/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.permission;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.CombinationPolicy;
import org.jboss.as.controller.access.constraint.Constraint;
import org.jboss.as.controller.access.permission.ManagementPermission;
import org.jboss.as.controller.access.permission.ManagementPermissionCollection;

public class CombinationManagementPermission
extends ManagementPermission {
    private final CombinationPolicy combinationPolicy;
    private final List<ManagementPermission> underlyingPermissions = new ArrayList<ManagementPermission>();

    public CombinationManagementPermission(CombinationPolicy combinationPolicy, Action.ActionEffect actionEffect) {
        super("CombinationManagementPermission", actionEffect);
        this.combinationPolicy = combinationPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUnderlyingPermission(ManagementPermission underlyingPermission) {
        assert (underlyingPermission.getActionEffect() == this.getActionEffect()) : "incompatible ActionEffect";
        if (this.combinationPolicy == CombinationPolicy.REJECTING && this.underlyingPermissions.size() > 0) {
            throw ControllerMessages.MESSAGES.illegalMultipleRoles();
        }
        List<ManagementPermission> list = this.underlyingPermissions;
        synchronized (list) {
            this.underlyingPermissions.add(underlyingPermission);
        }
    }

    @Override
    public String getActions() {
        TreeSet<Action.ActionEffect> effects = new TreeSet<Action.ActionEffect>();
        for (ManagementPermission permission : this.underlyingPermissions) {
            effects.add(permission.getActionEffect());
        }
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (Action.ActionEffect effect : effects) {
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(effect.toString());
        }
        return sb.toString();
    }

    @Override
    public boolean implies(Permission permission) {
        for (ManagementPermission underlying : this.underlyingPermissions) {
            if (this.combinationPolicy == CombinationPolicy.PERMISSIVE) {
                if (!underlying.implies(permission)) continue;
                return true;
            }
            if (underlying.implies(permission)) continue;
            return false;
        }
        return this.combinationPolicy != CombinationPolicy.PERMISSIVE;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new ManagementPermissionCollection(this.getClass());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CombinationManagementPermission that = (CombinationManagementPermission)o;
        return this.combinationPolicy == that.combinationPolicy && this.underlyingPermissions.equals(that.underlyingPermissions);
    }

    @Override
    public int hashCode() {
        int result = this.combinationPolicy.hashCode();
        result = 31 * result + this.underlyingPermissions.hashCode();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagementPermission createScopedPermission(Constraint constraint, int constraintIndex) {
        CombinationManagementPermission result = new CombinationManagementPermission(this.combinationPolicy, this.getActionEffect());
        List<ManagementPermission> list = this.underlyingPermissions;
        synchronized (list) {
            for (ManagementPermission underlying : this.underlyingPermissions) {
                result.addUnderlyingPermission(underlying.createScopedPermission(constraint, constraintIndex));
            }
        }
        return result;
    }
}

