/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.constraint;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.ServerGroupEffect;
import org.jboss.as.controller.access.TargetAttribute;
import org.jboss.as.controller.access.TargetResource;
import org.jboss.as.controller.access.constraint.AbstractConstraint;
import org.jboss.as.controller.access.constraint.AbstractConstraintFactory;
import org.jboss.as.controller.access.constraint.Constraint;
import org.jboss.as.controller.access.constraint.ScopingConstraint;
import org.jboss.as.controller.access.constraint.ScopingConstraintFactory;
import org.jboss.as.controller.access.rbac.StandardRole;

public class ServerGroupEffectConstraint
extends AbstractConstraint
implements Constraint,
ScopingConstraint {
    public static final ScopingConstraintFactory FACTORY = new Factory();
    private static final ServerGroupEffectConstraint GLOBAL_USER = new ServerGroupEffectConstraint(true);
    private static final ServerGroupEffectConstraint GLOBAL_REQUIRED = new ServerGroupEffectConstraint(false);
    private static final ServerGroupEffectConstraint UNASSIGNED = new ServerGroupEffectConstraint();
    private final boolean user;
    private final boolean global;
    private final boolean unassigned;
    private final GroupsHolder groupsHolder;
    private final boolean readOnly;
    private final ServerGroupEffectConstraint readOnlyConstraint;

    private ServerGroupEffectConstraint() {
        this.user = false;
        this.global = false;
        this.unassigned = true;
        this.readOnly = false;
        this.readOnlyConstraint = null;
        this.groupsHolder = new GroupsHolder();
    }

    private ServerGroupEffectConstraint(boolean user) {
        this.user = user;
        this.global = true;
        this.unassigned = false;
        this.readOnly = false;
        this.readOnlyConstraint = null;
        this.groupsHolder = new GroupsHolder();
    }

    private ServerGroupEffectConstraint(Set<String> allowed) {
        this.user = false;
        this.global = false;
        this.unassigned = false;
        this.groupsHolder = new GroupsHolder(allowed);
        this.readOnly = false;
        this.readOnlyConstraint = null;
    }

    public ServerGroupEffectConstraint(List<String> allowed) {
        this.user = true;
        this.global = false;
        this.unassigned = false;
        this.groupsHolder = new GroupsHolder(allowed);
        this.readOnly = false;
        this.readOnlyConstraint = new ServerGroupEffectConstraint(this.groupsHolder, true);
    }

    private ServerGroupEffectConstraint(GroupsHolder groupsHolder, boolean readOnly) {
        this.user = true;
        this.global = false;
        this.unassigned = false;
        this.groupsHolder = groupsHolder;
        this.readOnly = readOnly;
        this.readOnlyConstraint = null;
    }

    public void setAllowedGroups(List<String> allowed) {
        assert (!this.global) : "constraint is global";
        assert (this.readOnlyConstraint != null) : "invalid cast";
        this.groupsHolder.specific = new LinkedHashSet<String>(allowed);
    }

    @Override
    public boolean violates(Constraint other, Action.ActionEffect actionEffect) {
        if (other instanceof ServerGroupEffectConstraint) {
            ServerGroupEffectConstraint sgec = (ServerGroupEffectConstraint)other;
            Set ourSpecific = this.groupsHolder.specific;
            Set sgecSpecific = sgec.groupsHolder.specific;
            if (this.user) {
                assert (!sgec.user) : "illegal comparison";
                if (this.readOnly) {
                    if (!sgec.global) {
                        boolean anyMatch = this.anyMatch(ourSpecific, sgecSpecific);
                        if (!anyMatch) {
                            ControllerLogger.ACCESS_LOGGER.tracef("read-only server-group constraint violated for action %s due to no match between groups %s and allowed groups %s", (Object)actionEffect, sgecSpecific, ourSpecific);
                        }
                        return !anyMatch;
                    }
                } else if (!this.global) {
                    if (sgec.global) {
                        ControllerLogger.ACCESS_LOGGER.tracef("server-group constraint violated for action %s due to requirement for access to global resources", (Object)actionEffect);
                        return true;
                    }
                    if (!sgec.unassigned) {
                        if (actionEffect == Action.ActionEffect.WRITE_RUNTIME || actionEffect == Action.ActionEffect.WRITE_CONFIG) {
                            boolean containsAll = ourSpecific.containsAll(sgecSpecific);
                            if (!containsAll) {
                                ControllerLogger.ACCESS_LOGGER.tracef("server-group constraint violated for action %s due to mismatch of groups %s vs allowed %s", (Object)actionEffect, sgecSpecific, ourSpecific);
                            }
                            return !containsAll;
                        }
                        boolean anyMatch = this.anyMatch(ourSpecific, sgecSpecific);
                        if (!anyMatch) {
                            ControllerLogger.ACCESS_LOGGER.tracef("server-group constraint violated for action %s due to no match between groups %s and allowed groups %s", (Object)actionEffect, sgecSpecific, ourSpecific);
                        }
                        return !anyMatch;
                    }
                }
            } else {
                assert (sgec.user) : "illegal comparison";
                return other.violates(this, actionEffect);
            }
        }
        return false;
    }

    private boolean anyMatch(Set<String> ourSpecific, Set<String> sgecSpecific) {
        boolean matched = false;
        for (String ourGroup : ourSpecific) {
            if (!sgecSpecific.contains(ourGroup)) continue;
            matched = true;
            break;
        }
        if (!matched) {
            matched = sgecSpecific.size() == 1 && sgecSpecific.contains("*");
        }
        return matched;
    }

    @Override
    public boolean replaces(Constraint other) {
        return other instanceof ServerGroupEffectConstraint && (this.readOnly || this.readOnlyConstraint != null);
    }

    @Override
    public ScopingConstraintFactory getFactory() {
        assert (this.readOnlyConstraint != null) : "invalid cast";
        return FACTORY;
    }

    @Override
    public Constraint getStandardConstraint() {
        assert (this.readOnlyConstraint != null) : "invalid cast";
        return this;
    }

    @Override
    public Constraint getOutofScopeReadConstraint() {
        assert (this.readOnlyConstraint != null) : "invalid cast";
        return this.readOnlyConstraint;
    }

    private static class Factory
    extends AbstractConstraintFactory
    implements ScopingConstraintFactory {
        private Factory() {
        }

        @Override
        public Constraint getStandardUserConstraint(StandardRole role, Action.ActionEffect actionEffect) {
            return GLOBAL_USER;
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetAttribute target) {
            return this.getRequiredConstraint(target.getServerGroupEffect());
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetResource target) {
            return this.getRequiredConstraint(target.getServerGroupEffect());
        }

        private Constraint getRequiredConstraint(ServerGroupEffect serverGroupEffect) {
            if (serverGroupEffect == null || serverGroupEffect.isServerGroupEffectGlobal()) {
                return GLOBAL_REQUIRED;
            }
            if (serverGroupEffect.isServerGroupEffectUnassigned()) {
                return UNASSIGNED;
            }
            return new ServerGroupEffectConstraint(serverGroupEffect.getAffectedServerGroups());
        }

        @Override
        protected int internalCompare(AbstractConstraintFactory other) {
            return this.equals(other) ? 0 : -1;
        }
    }

    private static class GroupsHolder {
        private volatile Set<String> specific = new LinkedHashSet<String>();

        private GroupsHolder() {
        }

        private GroupsHolder(Collection<String> groups) {
            this.specific.addAll(groups);
        }
    }
}

