/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.permission;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.permission.ManagementPermission;

public class ManagementPermissionCollection
extends PermissionCollection {
    private final Class<? extends ManagementPermission> type;
    private final Map<Action.ActionEffect, ManagementPermission> permissions = new HashMap<Action.ActionEffect, ManagementPermission>();

    public ManagementPermissionCollection(Class<? extends ManagementPermission> type) {
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        if (this.type.equals(permission.getClass())) {
            ManagementPermission mperm = (ManagementPermission)permission;
            Map<Action.ActionEffect, ManagementPermission> map = this.permissions;
            synchronized (map) {
                this.permissions.put(mperm.getActionEffect(), mperm);
            }
        } else {
            throw new IllegalArgumentException("incompatible permission type " + permission.getClass());
        }
    }

    @Override
    public boolean implies(Permission permission) {
        if (permission instanceof ManagementPermission) {
            ManagementPermission mperm = (ManagementPermission)permission;
            ManagementPermission provided = this.permissions.get((Object)mperm.getActionEffect());
            return provided != null && provided.implies(mperm);
        }
        return false;
    }

    @Override
    public Enumeration<Permission> elements() {
        final Iterator<ManagementPermission> iterator = this.iterator();
        return new Enumeration<Permission>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public Permission nextElement() {
                return (Permission)iterator.next();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<ManagementPermission> iterator() {
        Map<Action.ActionEffect, ManagementPermission> map = this.permissions;
        synchronized (map) {
            return this.permissions.values().iterator();
        }
    }
}

