/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.constraint;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.TargetAttribute;
import org.jboss.as.controller.access.TargetResource;
import org.jboss.as.controller.access.constraint.AbstractConstraint;
import org.jboss.as.controller.access.constraint.AllowAllowNotConstraint;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.constraint.Constraint;
import org.jboss.as.controller.access.constraint.ConstraintFactory;
import org.jboss.as.controller.access.constraint.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.constraint.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.access.rbac.StandardRole;

public class ApplicationTypeConstraint
extends AllowAllowNotConstraint {
    public static final Factory FACTORY = new Factory();
    private static final ApplicationTypeConstraint APPLICATION = new ApplicationTypeConstraint(true);
    private static final ApplicationTypeConstraint NON_APPLICATION = new ApplicationTypeConstraint(false);

    private ApplicationTypeConstraint(boolean isApplication) {
        super(isApplication);
    }

    private ApplicationTypeConstraint(boolean allowsApplication, boolean allowsNonApplication) {
        super(allowsApplication, allowsNonApplication);
    }

    @Override
    protected int internalCompare(AbstractConstraint other) {
        return 0;
    }

    public static class Factory
    implements ConstraintFactory {
        private final Map<ApplicationTypeConfig.Key, ApplicationTypeConfig> typeConfigs = Collections.synchronizedMap(new HashMap());

        private Factory() {
        }

        @Override
        public Constraint getStandardUserConstraint(StandardRole role, Action.ActionEffect actionEffect) {
            boolean allowsNonApplication = role != StandardRole.DEPLOYER || actionEffect != Action.ActionEffect.WRITE_CONFIG && actionEffect != Action.ActionEffect.WRITE_RUNTIME;
            return new ApplicationTypeConstraint(true, allowsNonApplication);
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetAttribute target) {
            return this.isApplicationType(target.getTargetResource()) || this.isApplicationType(action) || this.isApplicationType(target) ? APPLICATION : NON_APPLICATION;
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetResource target) {
            return this.isApplicationType(action) || this.isApplicationType(target) ? APPLICATION : NON_APPLICATION;
        }

        private boolean isApplicationType(Action action) {
            for (AccessConstraintDefinition constraintDefinition : action.getAccessConstraints()) {
                ApplicationTypeAccessConstraintDefinition atcd;
                ApplicationTypeConfig atc;
                if (!(constraintDefinition instanceof ApplicationTypeAccessConstraintDefinition) || !(atc = (atcd = (ApplicationTypeAccessConstraintDefinition)constraintDefinition).getApplicationTypeConfig()).isApplicationType()) continue;
                return true;
            }
            return false;
        }

        private boolean isApplicationType(TargetAttribute target) {
            for (AccessConstraintDefinition constraintDefinition : target.getAccessConstraints()) {
                ApplicationTypeAccessConstraintDefinition atcd;
                ApplicationTypeConfig atc;
                if (!(constraintDefinition instanceof ApplicationTypeAccessConstraintDefinition) || !(atc = (atcd = (ApplicationTypeAccessConstraintDefinition)constraintDefinition).getApplicationTypeConfig()).isApplicationType()) continue;
                return true;
            }
            return false;
        }

        private boolean isApplicationType(TargetResource target) {
            for (AccessConstraintDefinition constraintDefinition : target.getAccessConstraints()) {
                ApplicationTypeAccessConstraintDefinition atcd;
                ApplicationTypeConfig atc;
                if (!(constraintDefinition instanceof ApplicationTypeAccessConstraintDefinition) || !(atc = (atcd = (ApplicationTypeAccessConstraintDefinition)constraintDefinition).getApplicationTypeConfig()).isApplicationType()) continue;
                return true;
            }
            return false;
        }

        public void addApplicationTypeConfig(ApplicationTypeConfig applicationTypeConfig) {
            ApplicationTypeConfig.Key key = applicationTypeConfig.getKey();
            ApplicationTypeConfig existing = this.typeConfigs.get(key);
            if (existing == null) {
                this.typeConfigs.put(key, applicationTypeConfig);
            } else if (!existing.isCompatibleWith(applicationTypeConfig)) {
                throw new IllegalStateException("incompatible ApplicationTypeConfig");
            }
        }

        public Collection<ApplicationTypeConfig> getApplicationTypeConfigs() {
            return Collections.unmodifiableCollection(this.typeConfigs.values());
        }
    }
}

