/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.access.Authorizer;
import org.jboss.as.controller.access.Caller;
import org.jboss.as.controller.access.ConfigurableAuthorizer;
import org.jboss.as.controller.access.Environment;
import org.jboss.as.controller.access.TargetAttribute;
import org.jboss.as.controller.access.TargetResource;
import org.jboss.as.controller.access.constraint.ScopingConstraint;
import org.jboss.as.controller.access.permission.CombinationPolicy;
import org.jboss.as.controller.access.permission.ManagementPermissionAuthorizer;
import org.jboss.as.controller.access.rbac.DefaultPermissionFactory;
import org.jboss.as.controller.access.rbac.MockRoleMapper;
import org.jboss.as.controller.access.rbac.RoleMapper;
import org.jboss.as.controller.access.rbac.StandardRole;

public class SimpleConfigurableAuthorizer
implements ConfigurableAuthorizer {
    private final RoleMapper roleMapper;
    private final DefaultPermissionFactory permissionFactory;
    private final Authorizer authorizer;
    private final Set<String> addedRoles = new HashSet<String>();

    public SimpleConfigurableAuthorizer() {
        this(MockRoleMapper.INSTANCE);
    }

    public SimpleConfigurableAuthorizer(RoleMapper roleMapper) {
        this.roleMapper = roleMapper;
        this.permissionFactory = new DefaultPermissionFactory(CombinationPolicy.PERMISSIVE, roleMapper);
        this.authorizer = new ManagementPermissionAuthorizer(this.permissionFactory);
    }

    @Override
    public boolean isRoleBased() {
        return true;
    }

    @Override
    public Set<String> getStandardRoles() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (StandardRole stdRole : StandardRole.values()) {
            result.add(stdRole.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getAllRoles() {
        Set<String> result = this.getStandardRoles();
        Set<String> set = this.addedRoles;
        synchronized (set) {
            result.addAll(this.addedRoles);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addScopedRole(String roleName, String baseRole, ScopingConstraint scopingConstraint) {
        Set<String> set = this.addedRoles;
        synchronized (set) {
            this.permissionFactory.addScopedRole(roleName, baseRole, scopingConstraint);
            this.addedRoles.add(roleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeScopedRole(String roleName) {
        Set<String> set = this.addedRoles;
        synchronized (set) {
            this.permissionFactory.removeScopedRole(roleName);
            this.addedRoles.remove(roleName);
        }
    }

    @Override
    public AuthorizationResult authorize(Caller caller, Environment callEnvironment, Action action, TargetAttribute target) {
        return this.authorizer.authorize(caller, callEnvironment, action, target);
    }

    @Override
    public AuthorizationResult authorize(Caller caller, Environment callEnvironment, Action action, TargetResource target) {
        return this.authorizer.authorize(caller, callEnvironment, action, target);
    }
}

