/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.access.constraint.management.AccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelType;

public class SimpleOperationDefinitionBuilder {
    private ResourceDescriptionResolver resolver;
    private ResourceDescriptionResolver attributeResolver;
    protected String name;
    protected OperationEntry.EntryType entryType = OperationEntry.EntryType.PUBLIC;
    protected EnumSet<OperationEntry.Flag> flags = EnumSet.noneOf(OperationEntry.Flag.class);
    protected AttributeDefinition[] parameters = new AttributeDefinition[0];
    protected ModelType replyType;
    protected ModelType replyValueType;
    protected boolean replyAllowNull;
    protected DeprecationData deprecationData = null;
    protected AttributeDefinition[] replyParameters = new AttributeDefinition[0];
    protected AccessConstraintDefinition[] accessConstraints;

    public SimpleOperationDefinitionBuilder(String name, ResourceDescriptionResolver resolver) {
        this.name = name;
        this.resolver = resolver;
    }

    public SimpleOperationDefinition build() {
        if (this.attributeResolver == null) {
            this.attributeResolver = this.resolver;
        }
        return this.internalBuild(this.resolver, this.attributeResolver);
    }

    protected SimpleOperationDefinition internalBuild(ResourceDescriptionResolver resolver, ResourceDescriptionResolver attributeResolver) {
        return new SimpleOperationDefinition(this.name, resolver, attributeResolver, this.entryType, this.flags, this.replyType, this.replyValueType, this.replyAllowNull, this.deprecationData, this.replyParameters, this.parameters, this.accessConstraints);
    }

    protected static EnumSet<OperationEntry.Flag> getFlagsSet(OperationEntry.Flag ... vararg) {
        if (vararg == null || vararg.length == 0) {
            return EnumSet.noneOf(OperationEntry.Flag.class);
        }
        EnumSet<OperationEntry.Flag> result = EnumSet.noneOf(OperationEntry.Flag.class);
        Collections.addAll(result, vararg);
        return result;
    }

    public SimpleOperationDefinitionBuilder setEntryType(OperationEntry.EntryType entryType) {
        this.entryType = entryType;
        return this;
    }

    public SimpleOperationDefinitionBuilder setPrivateEntry() {
        this.entryType = OperationEntry.EntryType.PRIVATE;
        return this;
    }

    public SimpleOperationDefinitionBuilder withFlags(EnumSet<OperationEntry.Flag> flags) {
        this.flags = flags;
        return this;
    }

    public SimpleOperationDefinitionBuilder withFlags(OperationEntry.Flag ... flags) {
        this.flags = SimpleOperationDefinitionBuilder.getFlagsSet(flags);
        return this;
    }

    public SimpleOperationDefinitionBuilder withFlag(OperationEntry.Flag flag) {
        this.flags = EnumSet.of(flag);
        return this;
    }

    public SimpleOperationDefinitionBuilder setRuntimeOnly() {
        this.flags = EnumSet.of(OperationEntry.Flag.RUNTIME_ONLY, (Enum[])this.flags.toArray(new OperationEntry.Flag[this.flags.size()]));
        return this;
    }

    public SimpleOperationDefinitionBuilder setReadOnly() {
        this.flags = EnumSet.of(OperationEntry.Flag.READ_ONLY, (Enum[])this.flags.toArray(new OperationEntry.Flag[this.flags.size()]));
        return this;
    }

    public SimpleOperationDefinitionBuilder setParameters(AttributeDefinition ... parameters) {
        this.parameters = parameters;
        return this;
    }

    public SimpleOperationDefinitionBuilder addParameter(AttributeDefinition parameter) {
        int i = this.parameters.length;
        this.parameters = Arrays.copyOf(this.parameters, i + 1);
        this.parameters[i] = parameter;
        return this;
    }

    public SimpleOperationDefinitionBuilder setReplyType(ModelType replyType) {
        this.replyType = replyType;
        return this;
    }

    public SimpleOperationDefinitionBuilder setReplyValueType(ModelType replyValueType) {
        this.replyValueType = replyValueType;
        return this;
    }

    public SimpleOperationDefinitionBuilder allowReturnNull() {
        this.replyAllowNull = true;
        return this;
    }

    public SimpleOperationDefinitionBuilder setDeprecated(ModelVersion since) {
        this.deprecationData = new DeprecationData(since);
        return this;
    }

    public SimpleOperationDefinitionBuilder setReplyParameters(AttributeDefinition ... replyParameters) {
        this.replyParameters = replyParameters;
        return this;
    }

    public SimpleOperationDefinitionBuilder setAttributeResolver(ResourceDescriptionResolver resolver) {
        this.attributeResolver = resolver;
        return this;
    }

    public SimpleOperationDefinitionBuilder setAccessConstraints(AccessConstraintDefinition ... accessConstraints) {
        this.accessConstraints = accessConstraints;
        return this;
    }

    public SimpleOperationDefinitionBuilder addAccessConstraint(AccessConstraintDefinition accessConstraint) {
        if (this.accessConstraints == null) {
            this.accessConstraints = new AccessConstraintDefinition[]{accessConstraint};
        } else {
            this.accessConstraints = Arrays.copyOf(this.accessConstraints, this.accessConstraints.length + 1);
            this.accessConstraints[this.accessConstraints.length - 1] = accessConstraint;
        }
        return this;
    }
}

