/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.command.CommandState;
import org.jboss.as.cli.parsing.operation.OperationRequestState;

public class InitialState
extends DefaultParsingState {
    public static final InitialState INSTANCE;
    public static final String ID = "INITIAL";

    InitialState() {
        this(OperationRequestState.INSTANCE, CommandState.INSTANCE);
    }

    InitialState(OperationRequestState opState, final CommandState cmdState) {
        super(ID);
        final LeadingWhitespaceState leadingWs = new LeadingWhitespaceState();
        leadingWs.setEndContentHandler(new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                ctx.enterState(cmdState);
            }
        });
        this.setEnterHandler(new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                if (Character.isWhitespace(ctx.getCharacter())) {
                    ctx.enterState(leadingWs);
                }
            }
        });
        this.enterState('.', opState);
        this.enterState(':', opState);
        this.enterState('/', opState);
        this.setDefaultHandler(new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                ctx.enterState(cmdState);
            }
        });
        this.setIgnoreWhitespaces(true);
    }

    static {
        OperationRequestState opState = new OperationRequestState();
        opState.setHandleEntrance(true);
        INSTANCE = new InitialState(opState, CommandState.INSTANCE);
    }

    class LeadingWhitespaceState
    extends DefaultParsingState {
        public LeadingWhitespaceState() {
            super("WS");
            this.setDefaultHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    if (!Character.isWhitespace(ctx.getCharacter())) {
                        ctx.leaveState();
                        InitialState.this.getHandler(ctx.getCharacter()).handle(ctx);
                    }
                }
            });
        }
    }
}

