/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.fluentd.runtime;

import java.util.HashMap;
import java.util.logging.Logger;
import org.fluentd.logger.sender.RawSocketSender;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;

public class FluentdHandler
extends ExtHandler {
    private static final Logger log = Logger.getLogger("org.wildfly.swarm.fluentd");
    private String hostname;
    private int port;
    private boolean initialized;
    private RawSocketSender sender;
    private String tag;

    public FluentdHandler() {
        this.setAutoFlush(false);
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPublish(ExtLogRecord record) {
        FluentdHandler fluentdHandler = this;
        synchronized (fluentdHandler) {
            if (!this.initialized) {
                try {
                    this.initialize();
                }
                catch (Exception e) {
                    this.reportError("Error creating fluentd connection", e, 4);
                    this.setEnabled(false);
                }
            }
        }
        if (this.initialized) {
            HashMap<String, Object> entries = new HashMap<String, Object>();
            entries.put(Key.SEQUENCE.getKey(), record.getSequenceNumber());
            entries.put(Key.LEVEL.getKey(), record.getLevel().getName());
            entries.put(Key.THREAD_NAME.getKey(), record.getThreadName());
            entries.put(Key.MESSAGE.getKey(), record.getFormattedMessage());
            entries.put(Key.THREAD_ID.getKey(), record.getThreadID());
            entries.put(Key.MDC.getKey(), record.getMdcCopy());
            entries.put(Key.NDC.getKey(), record.getNdc());
            this.sender.emit(this.tag, record.getMillis(), entries);
        }
    }

    private void initialize() {
        try {
            this.sender = new RawSocketSender(this.hostname, this.port);
            this.initialized = true;
            log.info("Connected to fluentd daemon");
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to initialise fluentd connection", t);
        }
    }

    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        log.info("Disconnect from fluentd daemon ...");
        FluentdHandler fluentdHandler = this;
        synchronized (fluentdHandler) {
            this.safeClose(this.sender);
            this.sender = null;
            this.initialized = false;
        }
    }

    private void safeClose(RawSocketSender c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Exception e) {
            this.reportError("Error closing resource", e, 3);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static enum Key {
        EXCEPTION("exception"),
        LEVEL("level"),
        LOGGER_CLASS_NAME("loggerClassName"),
        LOGGER_NAME("loggerName"),
        MDC("mdc"),
        MESSAGE("message"),
        NDC("ndc"),
        RECORD("record"),
        SEQUENCE("sequence"),
        THREAD_ID("threadId"),
        THREAD_NAME("threadName"),
        TIMESTAMP("timestamp");

        private final String key;

        private Key(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

