/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.fluentd.runtime;

import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.wildfly.swarm.config.logging.CustomHandler;
import org.wildfly.swarm.config.logging.Level;
import org.wildfly.swarm.fluentd.FluentdFraction;
import org.wildfly.swarm.fluentd.runtime.FluentdHandler;
import org.wildfly.swarm.logging.LoggingFraction;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.ConfigurationValue;
import org.wildfly.swarm.spi.runtime.annotations.Post;

@Post
@ApplicationScoped
public class FluentdCustomizer
implements Customizer {
    @Inject
    @Any
    private FluentdFraction fluentdFraction;
    @Inject
    @Any
    private LoggingFraction loggingFraction;
    @Inject
    @ConfigurationValue(value="swarm.fluentd.hostname")
    private Optional<String> hostname;
    @Inject
    @ConfigurationValue(value="swarm.fluentd.port")
    private Optional<Integer> port;

    public void customize() {
        String hostname = this.hostname.orElse(this.fluentdFraction.hostname());
        int port = this.port.orElse(this.fluentdFraction.port());
        if (hostname == null) {
            throw new IllegalArgumentException("Not enabling fluentd, no host set");
        }
        Properties handlerProps = new Properties();
        handlerProps.put("hostname", hostname);
        handlerProps.put("port", "" + port);
        handlerProps.put("tag", this.fluentdFraction.getTag());
        CustomHandler fluentd = new CustomHandler("fluentd-handler").module("org.wildfly.swarm.fluentd:runtime").attributeClass(FluentdHandler.class.getName()).properties((Map)handlerProps);
        Level level = this.fluentdFraction.level();
        ((LoggingFraction)this.loggingFraction.customHandler(fluentd)).rootLogger(level, new String[]{"CONSOLE", fluentd.getKey()});
    }
}

