/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.runtime.invocation;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.wildfly.swarm.config.runtime.invocation.ListTypeAdapter;
import org.wildfly.swarm.config.runtime.invocation.SimpleTypeAdapter;
import org.wildfly.swarm.config.runtime.invocation.Types;

public class MapTypeAdapter {
    public void toDmr(ModelNode target, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            ModelNode node = target.get(entry.getKey());
            Object value = entry.getValue();
            if (value instanceof List) {
                new ListTypeAdapter().toDmr(node, (List)value);
                continue;
            }
            if (value instanceof Map) {
                new MapTypeAdapter().toDmr(node, (Map)value);
                continue;
            }
            ModelType type = Types.resolveModelType(value.getClass());
            new SimpleTypeAdapter().toDmr(node, type, value);
        }
    }

    public void fromDmr(Object entity, String javaName, ModelType dmrType, Class<?> propertyType, ModelNode dmrPayload) throws Exception {
        List properties;
        Method target = entity.getClass().getMethod(javaName, propertyType);
        List list = properties = dmrPayload.isDefined() ? dmrPayload.asPropertyList() : Collections.EMPTY_LIST;
        if (properties.isEmpty()) {
            target.invoke(entity, Collections.EMPTY_MAP);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>(properties.size());
            for (Property prop : properties) {
                map.put(prop.getName(), this.toJavaValue(prop.getValue().getType(), prop.getValue()));
            }
            target.invoke(entity, map);
        }
    }

    private Object toJavaValue(ModelType type, ModelNode propValue) {
        if (type.equals((Object)ModelType.STRING)) {
            return propValue.asString();
        }
        if (type.equals((Object)ModelType.INT)) {
            return propValue.asInt();
        }
        if (type.equals((Object)ModelType.DOUBLE)) {
            return propValue.asDouble();
        }
        if (type.equals((Object)ModelType.LONG)) {
            return propValue.asLong();
        }
        if (type.equals((Object)ModelType.BOOLEAN)) {
            return propValue.asBoolean();
        }
        throw new RuntimeException("Unsupported DMR type: " + type);
    }
}

