/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.modules;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.xml.xpath.XPathExpressionException;
import org.jboss.modules.Module;
import org.jboss.modules.maven.ArtifactCoordinates;
import org.jboss.modules.maven.MavenArtifactUtil;
import org.jboss.modules.maven.MavenResolver;

public class GradleResolver
implements MavenResolver {
    private final String gradleCachePath;
    private final List<String> remoteRepositories = new LinkedList<String>();
    private static final String MD5_ALGORITHM = "md5";
    private static final char[] CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public GradleResolver(String gradleCachePath) {
        this.gradleCachePath = gradleCachePath;
        String remoteRepository = System.getProperty("remote.maven.repo");
        if (remoteRepository != null) {
            for (String repo : remoteRepository.split(",")) {
                if (!repo.endsWith("/")) {
                    this.remoteRepositories.add(repo + "/");
                    continue;
                }
                this.remoteRepositories.add(repo);
            }
        }
        this.remoteRepositories.add("https://repo1.maven.org/maven2/");
    }

    @Override
    public File resolveArtifact(ArtifactCoordinates artifactCoordinates, String packaging) throws IOException {
        String filter = this.toGradleArtifactFileName(artifactCoordinates, packaging);
        Path artifactDirectory = Paths.get(this.gradleCachePath, artifactCoordinates.getGroupId(), artifactCoordinates.getArtifactId(), artifactCoordinates.getVersion());
        if (Files.exists(artifactDirectory, new LinkOption[0])) {
            File latestArtifactFile = null;
            for (Path hashDir : Files.list(artifactDirectory).collect(Collectors.toList())) {
                for (Path artifact : Files.list(hashDir).collect(Collectors.toList())) {
                    if (!artifact.endsWith(filter)) continue;
                    File artifactFile = artifact.toFile();
                    if (latestArtifactFile != null && latestArtifactFile.lastModified() >= artifactFile.lastModified()) continue;
                    latestArtifactFile = artifactFile;
                }
            }
            if (latestArtifactFile != null) {
                return latestArtifactFile;
            }
        }
        return this.downloadFromRemoteRepository(artifactCoordinates, packaging, artifactDirectory);
    }

    File downloadFromRemoteRepository(ArtifactCoordinates artifactCoordinates, String packaging, Path artifactDirectory) {
        String artifactRelativeHttpPath = artifactCoordinates.relativeArtifactPath('/');
        String artifactRelativeMetadataHttpPath = artifactCoordinates.relativeMetadataPath('/');
        for (String remoteRepos : this.remoteRepositories) {
            File targetArtifactDirectory;
            File targetArtifactPomDirectory;
            String artifactAbsoluteHttpPath;
            File artifactFile = this.doDownload(remoteRepos, artifactAbsoluteHttpPath = remoteRepos + artifactRelativeHttpPath + ".", artifactRelativeHttpPath, artifactCoordinates, packaging, targetArtifactPomDirectory = artifactDirectory.resolve(this.computeGradleUUID(artifactCoordinates + ":pom")).toFile(), targetArtifactDirectory = artifactDirectory.resolve(this.computeGradleUUID(artifactCoordinates + ":" + packaging)).toFile());
            if (artifactFile != null) {
                return artifactFile;
            }
            if (!artifactCoordinates.isSnapshot()) continue;
            String remoteMetadataPath = remoteRepos + artifactRelativeMetadataHttpPath;
            try {
                File targetTimestampedArtifactDirectory;
                File targetTimestampedArtifactPomDirectory;
                String timestamp = MavenArtifactUtil.downloadTimestampVersion(artifactCoordinates + ":" + packaging, remoteMetadataPath);
                String timestampedArtifactRelativePath = artifactCoordinates.relativeArtifactPath('/', timestamp);
                String artifactTimestampedAbsoluteHttpPath = remoteRepos + timestampedArtifactRelativePath + ".";
                File snapshotArtifactFile = this.doDownload(remoteRepos, artifactTimestampedAbsoluteHttpPath, timestampedArtifactRelativePath, artifactCoordinates, packaging, targetTimestampedArtifactPomDirectory = artifactDirectory.resolve(this.computeGradleUUID(artifactCoordinates + ":" + timestamp + ":pom")).toFile(), targetTimestampedArtifactDirectory = artifactDirectory.resolve(this.computeGradleUUID(artifactCoordinates + ":" + packaging)).toFile());
                if (snapshotArtifactFile == null) continue;
                return snapshotArtifactFile;
            }
            catch (IOException | XPathExpressionException ex) {
                Module.getModuleLogger().trace((Throwable)ex, "Could not doDownload '%s' from '%s' repository", (Object)artifactRelativeHttpPath, (Object)remoteRepos);
            }
        }
        return null;
    }

    File doDownload(String remoteRepos, String artifactAbsoluteHttpPath, String artifactRelativeHttpPath, ArtifactCoordinates artifactCoordinates, String packaging, File targetArtifactPomDirectory, File targetArtifactDirectory) {
        File targetArtifactPomFile = new File(targetArtifactPomDirectory, this.toGradleArtifactFileName(artifactCoordinates, "pom"));
        try {
            MavenArtifactUtil.downloadFile(artifactCoordinates + ":pom", artifactAbsoluteHttpPath + "pom", targetArtifactPomFile);
        }
        catch (IOException e) {
            Module.getModuleLogger().trace((Throwable)e, "Could not doDownload '%s' from '%s' repository", (Object)artifactRelativeHttpPath, (Object)remoteRepos);
        }
        File targetArtifactFile = new File(targetArtifactDirectory, this.toGradleArtifactFileName(artifactCoordinates, packaging));
        try {
            MavenArtifactUtil.downloadFile(artifactCoordinates + ":" + packaging, artifactAbsoluteHttpPath + packaging, targetArtifactFile);
            if (targetArtifactFile.exists()) {
                return targetArtifactFile;
            }
        }
        catch (IOException e) {
            Module.getModuleLogger().trace((Throwable)e, "Could not doDownload '%s' from '%s' repository", (Object)artifactRelativeHttpPath, (Object)remoteRepos);
        }
        return null;
    }

    String toGradleArtifactFileName(ArtifactCoordinates artifactCoordinates, String packaging) {
        StringBuilder sbFileFilter = new StringBuilder();
        sbFileFilter.append(artifactCoordinates.getArtifactId()).append("-").append(artifactCoordinates.getVersion());
        if (artifactCoordinates.getClassifier() != null && artifactCoordinates.getClassifier().length() > 0) {
            sbFileFilter.append("-").append(artifactCoordinates.getClassifier());
        }
        sbFileFilter.append(".").append(packaging);
        return sbFileFilter.toString();
    }

    String computeGradleUUID(String content) {
        try {
            MessageDigest md = MessageDigest.getInstance(MD5_ALGORITHM);
            md.reset();
            byte[] bytes = content.trim().toLowerCase(Locale.US).getBytes("UTF-8");
            md.update(bytes, 0, bytes.length);
            return this.byteArrayToHexString(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("unknown algorithm md5", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("unknown charset UTF-8", e);
        }
    }

    String byteArrayToHexString(byte[] in) {
        byte ch = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        StringBuffer out = new StringBuffer(in.length * 2);
        for (byte b : in) {
            ch = (byte)(b & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(CHARS[ch]);
            ch = (byte)(b & 0xF);
            out.append(CHARS[ch]);
        }
        return out.toString();
    }
}

