/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.jose.jwk;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.jose.jwk.ElytronMessages;
import org.wildfly.security.jose.jwk.JWK;
import org.wildfly.security.jose.jwk.JWKUtil;
import org.wildfly.security.jose.util.JsonSerialization;

public class JWKParser {
    private JWK jwk;

    private JWKParser() {
    }

    public JWKParser(JWK jwk) {
        this.jwk = jwk;
    }

    public static JWKParser create() {
        return new JWKParser();
    }

    public static JWKParser create(JWK jwk) {
        return new JWKParser(jwk);
    }

    public JWKParser parse(String jwk) {
        try {
            this.jwk = JsonSerialization.mapper.readValue(jwk, JWK.class);
            return this;
        }
        catch (Exception e) {
            throw ElytronMessages.log.unableToParseStringJWK(e);
        }
    }

    public JWK getJwk() {
        return this.jwk;
    }

    public PublicKey toPublicKey() {
        return JWKParser.toPublicKey(this.jwk);
    }

    public static PublicKey toPublicKey(JWK jwk) {
        String keyType = jwk.getKeyType();
        if (keyType.equals("RSA")) {
            return JWKParser.createRSAPublicKey(jwk);
        }
        if (keyType.equals("EC")) {
            return JWKParser.createECPublicKey(jwk);
        }
        throw ElytronMessages.log.unsupportedKeyTypeForJWK(keyType);
    }

    public static boolean isKeyTypeSupported(String keyType) {
        return "RSA".equals(keyType) || "EC".equals(keyType);
    }

    private static PublicKey createECPublicKey(JWK jwk) {
        String curveName;
        String crv = (String)jwk.getOtherClaims().get("crv");
        BigInteger x = new BigInteger(1, CodePointIterator.ofString((String)((String)jwk.getOtherClaims().get("x"))).base64Decode(JWKUtil.BASE64_URL, false).drain());
        BigInteger y = new BigInteger(1, CodePointIterator.ofString((String)((String)jwk.getOtherClaims().get("y"))).base64Decode(JWKUtil.BASE64_URL, false).drain());
        switch (crv) {
            case "P-256": {
                curveName = "secp256r1";
                break;
            }
            case "P-384": {
                curveName = "secp384r1";
                break;
            }
            case "P-521": {
                curveName = "secp521r1";
                break;
            }
            default: {
                throw ElytronMessages.log.unsupportedCurve();
            }
        }
        try {
            AlgorithmParameters params = AlgorithmParameters.getInstance("EC");
            params.init(new ECGenParameterSpec(curveName));
            ECPoint point = new ECPoint(x, y);
            KeyFactory kf = KeyFactory.getInstance("EC");
            return kf.generatePublic(new ECPublicKeySpec(point, params.getParameterSpec(ECParameterSpec.class)));
        }
        catch (Exception e) {
            throw ElytronMessages.log.unableToCreatePublicKeyFromJWK(e);
        }
    }

    private static PublicKey createRSAPublicKey(JWK jwk) {
        BigInteger modulus = new BigInteger(1, CodePointIterator.ofString((String)jwk.getOtherClaims().get("n").toString()).base64Decode(JWKUtil.BASE64_URL, false).drain());
        BigInteger publicExponent = new BigInteger(1, CodePointIterator.ofString((String)jwk.getOtherClaims().get("e").toString()).base64Decode(JWKUtil.BASE64_URL, false).drain());
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePublic(new RSAPublicKeySpec(modulus, publicExponent));
        }
        catch (Exception e) {
            throw ElytronMessages.log.unableToCreatePublicKeyFromJWK(e);
        }
    }
}

