/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wildfly.security.http.oidc.Encode;
import org.wildfly.security.http.oidc.PathHelper;

class OidcClientUriBuilder {
    private String host;
    private String scheme;
    private int port = -1;
    private boolean preserveDefaultPort = false;
    private String userInfo;
    private String path;
    private String query;
    private String fragment;
    private String ssp;
    private String authority;
    private static final Pattern opaqueUri = Pattern.compile("^([^:/?#]+):([^/].*)");
    private static final Pattern hierarchicalUri = Pattern.compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");
    private static final Pattern hostPortPattern = Pattern.compile("([^/:]+):(\\d+)");
    private static final Pattern PARAM_REPLACEMENT = Pattern.compile("_resteasy_uri_parameter");

    OidcClientUriBuilder() {
    }

    public static OidcClientUriBuilder fromUri(String uriTemplate) {
        return new OidcClientUriBuilder().uri(uriTemplate, true);
    }

    public static OidcClientUriBuilder fromPath(String path) throws IllegalArgumentException {
        return new OidcClientUriBuilder().path(path);
    }

    public OidcClientUriBuilder clone() {
        OidcClientUriBuilder impl = new OidcClientUriBuilder();
        impl.host = this.host;
        impl.scheme = this.scheme;
        impl.port = this.port;
        impl.userInfo = this.userInfo;
        impl.path = this.path;
        impl.query = this.query;
        impl.fragment = this.fragment;
        impl.ssp = this.ssp;
        impl.authority = this.authority;
        return impl;
    }

    public static boolean compare(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static URI relativize(URI from, URI to) {
        int i;
        if (!OidcClientUriBuilder.compare(from.getScheme(), to.getScheme())) {
            return to;
        }
        if (!OidcClientUriBuilder.compare(from.getHost(), to.getHost())) {
            return to;
        }
        if (from.getPort() != to.getPort()) {
            return to;
        }
        if (from.getPath() == null && to.getPath() == null) {
            return URI.create("");
        }
        if (from.getPath() == null) {
            return URI.create(to.getPath());
        }
        if (to.getPath() == null) {
            return to;
        }
        String fromPath = from.getPath();
        if (fromPath.startsWith("/")) {
            fromPath = fromPath.substring(1);
        }
        String[] fsplit = fromPath.split("/");
        String toPath = to.getPath();
        if (toPath.startsWith("/")) {
            toPath = toPath.substring(1);
        }
        String[] tsplit = toPath.split("/");
        for (int f = 0; f < fsplit.length && f < tsplit.length && fsplit[f].equals(tsplit[f]); ++f) {
        }
        OidcClientUriBuilder builder = OidcClientUriBuilder.fromPath("");
        for (i = f; i < fsplit.length; ++i) {
            builder.path("..");
        }
        for (i = f; i < tsplit.length; ++i) {
            builder.path(tsplit[i]);
        }
        return builder.build(new Object[0]);
    }

    public static OidcClientUriBuilder fromTemplate(String uriTemplate) {
        OidcClientUriBuilder impl = new OidcClientUriBuilder();
        impl.uriTemplate(uriTemplate);
        return impl;
    }

    public OidcClientUriBuilder uriTemplate(String uriTemplate) {
        return this.uri(uriTemplate, true);
    }

    protected OidcClientUriBuilder parseHierarchicalUri(String uri, Matcher match, boolean template) {
        String authority;
        boolean scheme;
        boolean bl = scheme = match.group(2) != null;
        if (scheme) {
            this.scheme = match.group(2);
        }
        if ((authority = match.group(4)) != null) {
            Matcher hostPortMatch;
            this.authority = null;
            String host = match.group(4);
            int at = host.indexOf(64);
            if (at > -1) {
                String user = host.substring(0, at);
                host = host.substring(at + 1);
                this.replaceUserInfo(user, template);
            }
            if ((hostPortMatch = hostPortPattern.matcher(host)).matches()) {
                this.host = hostPortMatch.group(1);
                try {
                    this.port = Integer.parseInt(hostPortMatch.group(2));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal uri template: " + uri, e);
                }
            } else {
                this.host = host;
            }
        }
        if (match.group(5) != null) {
            String group = match.group(5);
            if (!(scheme || "".equals(group) || group.startsWith("/") || group.indexOf(58) <= -1)) {
                throw new IllegalArgumentException("Illegal uri template: " + uri);
            }
            if (!"".equals(group)) {
                this.replacePath(group, template);
            }
        }
        if (match.group(7) != null) {
            this.replaceQuery(match.group(7), template);
        }
        if (match.group(9) != null) {
            this.fragment(match.group(9), template);
        }
        return this;
    }

    public OidcClientUriBuilder uri(String uri) throws IllegalArgumentException {
        return this.uri(uri, true);
    }

    public OidcClientUriBuilder uri(String uri, boolean template) throws IllegalArgumentException {
        if (uri == null) {
            throw new IllegalArgumentException("uri parameter is null");
        }
        Matcher opaque = opaqueUri.matcher(uri);
        if (opaque.matches()) {
            this.authority = null;
            this.host = null;
            this.port = -1;
            this.userInfo = null;
            this.query = null;
            this.scheme = opaque.group(1);
            this.ssp = opaque.group(2);
            return this;
        }
        Matcher match = hierarchicalUri.matcher(uri);
        if (match.matches()) {
            this.ssp = null;
            return this.parseHierarchicalUri(uri, match, template);
        }
        throw new IllegalArgumentException("Illegal uri template: " + uri);
    }

    public OidcClientUriBuilder uri(URI uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new IllegalArgumentException("URI was null");
        }
        if (uri.getRawFragment() != null) {
            this.fragment = uri.getRawFragment();
        }
        if (uri.isOpaque()) {
            this.scheme = uri.getScheme();
            this.ssp = uri.getRawSchemeSpecificPart();
            return this;
        }
        if (uri.getScheme() == null) {
            if (this.ssp != null && uri.getRawSchemeSpecificPart() != null) {
                this.ssp = uri.getRawSchemeSpecificPart();
                return this;
            }
        } else {
            this.scheme = uri.getScheme();
        }
        this.ssp = null;
        if (uri.getRawAuthority() != null) {
            if (uri.getRawUserInfo() == null && uri.getHost() == null && uri.getPort() == -1) {
                this.authority = uri.getRawAuthority();
                this.userInfo = null;
                this.host = null;
                this.port = -1;
            } else {
                this.authority = null;
                if (uri.getRawUserInfo() != null) {
                    this.userInfo = uri.getRawUserInfo();
                }
                if (uri.getHost() != null) {
                    this.host = uri.getHost();
                }
                if (uri.getPort() != -1) {
                    this.port = uri.getPort();
                }
            }
        }
        if (uri.getRawPath() != null && uri.getRawPath().length() > 0) {
            this.path = uri.getRawPath();
        }
        if (uri.getRawQuery() != null && uri.getRawQuery().length() > 0) {
            this.query = uri.getRawQuery();
        }
        return this;
    }

    protected static String paths(boolean encode, String basePath, String ... segments) {
        String path = basePath;
        if (path == null) {
            path = "";
        }
        for (String segment : segments) {
            if ("".equals(segment)) continue;
            if (path.endsWith("/")) {
                if (segment.startsWith("/") && "".equals(segment = segment.substring(1))) continue;
                if (encode) {
                    segment = Encode.encodePath(segment);
                }
                path = path + segment;
                continue;
            }
            if (encode) {
                segment = Encode.encodePath(segment);
            }
            path = "".equals(path) ? segment : (segment.startsWith("/") ? path + segment : path + "/" + segment);
        }
        return path;
    }

    public OidcClientUriBuilder path(String segment) throws IllegalArgumentException {
        if (segment == null) {
            throw new IllegalArgumentException("path was null");
        }
        this.path = OidcClientUriBuilder.paths(true, this.path, segment);
        return this;
    }

    public OidcClientUriBuilder replaceQuery(String query, boolean template) throws IllegalArgumentException {
        if (query == null || query.length() == 0) {
            this.query = null;
            return this;
        }
        this.query = template ? Encode.encodeQueryString(query) : Encode.encodeQueryStringNotTemplateParameters(query);
        return this;
    }

    public OidcClientUriBuilder fragment(String fragment, boolean template) throws IllegalArgumentException {
        if (fragment == null) {
            this.fragment = null;
            return this;
        }
        this.fragment = template ? Encode.encodeFragment(fragment) : Encode.encodeFragmentNotTemplateParameters(fragment);
        return this;
    }

    private String buildString(Map<String, ?> paramMap, boolean fromEncodedMap, boolean isTemplate, boolean encodeSlash) {
        for (Map.Entry<String, ?> entry : paramMap.entrySet()) {
            if (entry.getKey() == null) {
                throw new IllegalArgumentException("map key is null");
            }
            if (entry.getValue() != null) continue;
            throw new IllegalArgumentException("map value is null");
        }
        StringBuffer buffer = new StringBuffer();
        if (this.scheme != null) {
            this.replaceParameter(paramMap, fromEncodedMap, isTemplate, this.scheme, buffer, encodeSlash).append(":");
        }
        if (this.ssp != null) {
            buffer.append(this.ssp);
        } else if (this.userInfo != null || this.host != null || this.port != -1) {
            buffer.append("//");
            if (this.userInfo != null) {
                this.replaceUserInfoParameter(paramMap, fromEncodedMap, isTemplate, this.userInfo, buffer).append("@");
            }
            if (this.host != null) {
                if ("".equals(this.host)) {
                    throw new RuntimeException("empty host name");
                }
                this.replaceParameter(paramMap, fromEncodedMap, isTemplate, this.host, buffer, encodeSlash);
            }
            if (!(this.port == -1 || !this.preserveDefaultPort && ("http".equals(this.scheme) && this.port == 80 || "https".equals(this.scheme) && this.port == 443))) {
                buffer.append(":").append(Integer.toString(this.port));
            }
        } else if (this.authority != null) {
            buffer.append("//");
            this.replaceParameter(paramMap, fromEncodedMap, isTemplate, this.authority, buffer, encodeSlash);
        }
        if (this.path != null) {
            StringBuffer tmp = new StringBuffer();
            this.replaceParameter(paramMap, fromEncodedMap, isTemplate, this.path, tmp, encodeSlash);
            String tmpPath = tmp.toString();
            if (!(this.userInfo == null && this.host == null || tmpPath.startsWith("/"))) {
                buffer.append("/");
            }
            buffer.append(tmpPath);
        }
        if (this.query != null) {
            buffer.append("?");
            this.replaceQueryStringParameter(paramMap, fromEncodedMap, isTemplate, this.query, buffer);
        }
        if (this.fragment != null) {
            buffer.append("#");
            this.replaceParameter(paramMap, fromEncodedMap, isTemplate, this.fragment, buffer, encodeSlash);
        }
        return buffer.toString();
    }

    public static Matcher createUriParamMatcher(String string) {
        return PathHelper.URI_PARAM_PATTERN.matcher(PathHelper.replaceEnclosedCurlyBraces(string));
    }

    protected StringBuffer replaceParameter(Map<String, ?> paramMap, boolean fromEncodedMap, boolean isTemplate, String string, StringBuffer buffer, boolean encodeSlash) {
        Matcher matcher = OidcClientUriBuilder.createUriParamMatcher(string);
        while (matcher.find()) {
            String param = matcher.group(1);
            Object valObj = paramMap.get(param);
            if (valObj == null && !isTemplate) {
                throw new IllegalArgumentException("NULL value for template parameter: " + param);
            }
            if (valObj == null && isTemplate) {
                matcher.appendReplacement(buffer, matcher.group());
                continue;
            }
            String value = valObj.toString();
            if (value != null) {
                value = !fromEncodedMap ? (encodeSlash ? Encode.encodePathSegmentAsIs(value) : Encode.encodePathAsIs(value)) : (encodeSlash ? Encode.encodePathSegmentSaveEncodings(value) : Encode.encodePathSaveEncodings(value));
                matcher.appendReplacement(buffer, Matcher.quoteReplacement(value));
                continue;
            }
            throw new IllegalArgumentException("path param " + param + " has not been provided by the parameter map");
        }
        matcher.appendTail(buffer);
        return buffer;
    }

    protected StringBuffer replaceQueryStringParameter(Map<String, ?> paramMap, boolean fromEncodedMap, boolean isTemplate, String string, StringBuffer buffer) {
        Matcher matcher = OidcClientUriBuilder.createUriParamMatcher(string);
        while (matcher.find()) {
            String param = matcher.group(1);
            Object valObj = paramMap.get(param);
            if (valObj == null && !isTemplate) {
                throw new IllegalArgumentException("NULL value for template parameter: " + param);
            }
            if (valObj == null && isTemplate) {
                matcher.appendReplacement(buffer, matcher.group());
                continue;
            }
            String value = valObj.toString();
            if (value != null) {
                value = !fromEncodedMap ? Encode.encodeQueryParamAsIs(value) : Encode.encodeQueryParamSaveEncodings(value);
                matcher.appendReplacement(buffer, value);
                continue;
            }
            throw new IllegalArgumentException("path param " + param + " has not been provided by the parameter map");
        }
        matcher.appendTail(buffer);
        return buffer;
    }

    protected StringBuffer replaceUserInfoParameter(Map<String, ?> paramMap, boolean fromEncodedMap, boolean isTemplate, String string, StringBuffer buffer) {
        Matcher matcher = OidcClientUriBuilder.createUriParamMatcher(string);
        while (matcher.find()) {
            String param = matcher.group(1);
            Object valObj = paramMap.get(param);
            if (valObj == null && !isTemplate) {
                throw new IllegalArgumentException("NULL value for template parameter: " + param);
            }
            if (valObj == null && isTemplate) {
                matcher.appendReplacement(buffer, matcher.group());
                continue;
            }
            String value = valObj.toString();
            if (value != null) {
                value = !fromEncodedMap ? Encode.encodeUserInfoAsIs(value) : Encode.encodeUserInfoSaveEncodings(value);
                matcher.appendReplacement(buffer, value);
                continue;
            }
            throw new IllegalArgumentException("path param " + param + " has not been provided by the parameter map");
        }
        matcher.appendTail(buffer);
        return buffer;
    }

    public List<String> getPathParamNamesInDeclarationOrder() {
        ArrayList<String> params = new ArrayList<String>();
        HashSet<String> set = new HashSet<String>();
        if (this.scheme != null) {
            this.addToPathParamList(params, set, this.scheme);
        }
        if (this.userInfo != null) {
            this.addToPathParamList(params, set, this.userInfo);
        }
        if (this.host != null) {
            this.addToPathParamList(params, set, this.host);
        }
        if (this.path != null) {
            this.addToPathParamList(params, set, this.path);
        }
        if (this.query != null) {
            this.addToPathParamList(params, set, this.query);
        }
        if (this.fragment != null) {
            this.addToPathParamList(params, set, this.fragment);
        }
        return params;
    }

    private void addToPathParamList(List<String> params, HashSet<String> set, String string) {
        Matcher matcher = PathHelper.URI_PARAM_PATTERN.matcher(PathHelper.replaceEnclosedCurlyBraces(string));
        while (matcher.find()) {
            String param = matcher.group(1);
            if (set.contains(param)) continue;
            set.add(param);
            params.add(param);
        }
    }

    public URI build(Object ... values) throws IllegalArgumentException {
        if (values == null) {
            throw new IllegalArgumentException("values parameter is null");
        }
        return this.buildFromValues(true, false, values);
    }

    public String buildAsString(Object ... values) throws IllegalArgumentException {
        if (values == null) {
            throw new IllegalArgumentException("values parameter is null");
        }
        return this.buildFromValuesAsString(true, false, values);
    }

    protected URI buildFromValues(boolean encodeSlash, boolean encoded, Object ... values) {
        String buf = this.buildFromValuesAsString(encodeSlash, encoded, values);
        try {
            return new URI(buf);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create URI: " + buf, e);
        }
    }

    protected String buildFromValuesAsString(boolean encodeSlash, boolean encoded, Object ... values) {
        List<String> params = this.getPathParamNamesInDeclarationOrder();
        if (values.length < params.size()) {
            throw new IllegalArgumentException("You did not supply enough values to fill path parameters");
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        for (int i = 0; i < params.size(); ++i) {
            String pathParam = params.get(i);
            Object val = values[i];
            if (val == null) {
                throw new IllegalArgumentException("A value was null");
            }
            pathParams.put(pathParam, val.toString());
        }
        return this.buildString(pathParams, encoded, false, encodeSlash);
    }

    public OidcClientUriBuilder matrixParam(String name, Object ... values) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name parameter is null");
        }
        if (values == null) {
            throw new IllegalArgumentException("values parameter is null");
        }
        if (this.path == null) {
            this.path = "";
        }
        for (Object val : values) {
            if (val == null) {
                throw new IllegalArgumentException("null value");
            }
            this.path = this.path + ";" + Encode.encodeMatrixParam(name) + "=" + Encode.encodeMatrixParam(val.toString());
        }
        return this;
    }

    public OidcClientUriBuilder queryParam(String name, Object ... values) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name parameter is null");
        }
        if (values == null) {
            throw new IllegalArgumentException("values parameter is null");
        }
        for (Object value : values) {
            if (value == null) {
                throw new IllegalArgumentException("A passed in value was null");
            }
            this.query = this.query == null ? "" : this.query + "&";
            this.query = this.query + Encode.encodeQueryParamAsIs(name) + "=" + Encode.encodeQueryParamAsIs(value.toString());
        }
        return this;
    }

    public OidcClientUriBuilder replaceQueryParam(String name, Object ... values) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name parameter is null");
        }
        if (this.query == null || this.query.equals("")) {
            if (values != null) {
                return this.queryParam(name, values);
            }
            return this;
        }
        String[] params = this.query.split("&");
        this.query = null;
        String replacedName = Encode.encodeQueryParam(name);
        for (String param : params) {
            String paramName;
            int pos = param.indexOf(61);
            if (pos < 0 ? param.equals(replacedName) : (paramName = param.substring(0, pos)).equals(replacedName)) continue;
            this.query = this.query == null ? "" : this.query + "&";
            this.query = this.query + param;
        }
        if (values == null) {
            return this;
        }
        return this.queryParam(name, values);
    }

    public String getHost() {
        return this.host;
    }

    public String getScheme() {
        return this.scheme;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public String getFragment() {
        return this.fragment;
    }

    public OidcClientUriBuilder replacePath(String path, boolean template) {
        if (path == null) {
            this.path = null;
            return this;
        }
        this.path = template ? Encode.encodePath(path) : Encode.encodePathSaveEncodings(path);
        return this;
    }

    public OidcClientUriBuilder replaceUserInfo(String userInfo, boolean template) {
        if (userInfo == null) {
            this.userInfo = null;
            return this;
        }
        this.userInfo = template ? Encode.encodeUserInfo(userInfo) : Encode.encodeUserInfoNotTemplateParameters(userInfo);
        return this;
    }

    public URI build(Object[] values, boolean encodeSlashInPath) throws IllegalArgumentException {
        if (values == null) {
            throw new IllegalArgumentException("values param is null");
        }
        return this.buildFromValues(encodeSlashInPath, false, values);
    }

    public OidcClientUriBuilder resolveTemplates(Map<String, Object> templateValues) throws IllegalArgumentException {
        if (templateValues == null) {
            throw new IllegalArgumentException("templateValues param null");
        }
        String str = this.buildString(templateValues, false, true, true);
        return OidcClientUriBuilder.fromTemplate(str);
    }
}

