/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Map;
import java.util.TreeMap;

@JsonPropertyOrder(value={"realm", "realm-public-key", "auth-server-url", "ssl-required", "resource", "public-client", "credentials", "use-resource-role-mappings", "use-realm-role-mappings", "enable-cors", "cors-max-age", "cors-allowed-methods", "cors-exposed-headers", "expose-token", "bearer-only", "autodetect-bearer-only", "connection-pool-size", "allow-any-hostname", "disable-trust-manager", "truststore", "truststore-password", "client-keystore", "client-keystore-password", "client-key-password", "always-refresh-token", "register-node-at-startup", "register-node-period", "token-store", "adapter-state-cookie-path", "principal-attribute", "proxy-url", "turn-off-change-session-id-on-login", "token-minimum-time-to-live", "min-time-between-jwks-requests", "public-key-cache-ttl", "ignore-oauth-query-parameter", "verify-token-audience", "token-signature-algorithm", "scope"})
public class OidcJsonConfiguration {
    @JsonProperty(value="allow-any-hostname")
    protected boolean allowAnyHostname;
    @JsonProperty(value="disable-trust-manager")
    protected boolean disableTrustManager;
    @JsonProperty(value="truststore")
    protected String truststore;
    @JsonProperty(value="truststore-password")
    protected String truststorePassword;
    @JsonProperty(value="client-keystore")
    protected String clientKeystore;
    @JsonProperty(value="client-keystore-password")
    protected String clientKeystorePassword;
    @JsonProperty(value="client-key-password")
    protected String clientKeyPassword;
    @JsonProperty(value="connection-pool-size")
    protected int connectionPoolSize = 20;
    @JsonProperty(value="always-refresh-token")
    protected boolean alwaysRefreshToken = false;
    @JsonProperty(value="register-node-at-startup")
    protected boolean registerNodeAtStartup = false;
    @JsonProperty(value="register-node-period")
    protected int registerNodePeriod = -1;
    @JsonProperty(value="token-store")
    protected String tokenStore;
    @JsonProperty(value="adapter-state-cookie-path")
    protected String tokenCookiePath;
    @JsonProperty(value="principal-attribute")
    protected String principalAttribute;
    @JsonProperty(value="turn-off-change-session-id-on-login")
    protected Boolean turnOffChangeSessionIdOnLogin;
    @JsonProperty(value="token-minimum-time-to-live")
    protected int tokenMinimumTimeToLive = 0;
    @JsonProperty(value="min-time-between-jwks-requests")
    protected int minTimeBetweenJwksRequests = 10;
    @JsonProperty(value="public-key-cache-ttl")
    protected int publicKeyCacheTtl = 86400;
    @JsonProperty(value="enable-pkce")
    protected boolean pkce = false;
    @JsonProperty(value="ignore-oauth-query-parameter")
    protected boolean ignoreOAuthQueryParameter = false;
    @JsonProperty(value="verify-token-audience")
    protected boolean verifyTokenAudience = false;
    @JsonProperty(value="confidential-port")
    protected int confidentialPort;
    @JsonProperty(value="resource")
    protected String resource;
    @JsonProperty(value="use-resource-role-mappings")
    protected boolean useResourceRoleMappings;
    @JsonProperty(value="use-realm-role-mappings")
    protected boolean useRealmRoleMappings = true;
    @JsonProperty(value="enable-cors")
    protected boolean cors;
    @JsonProperty(value="cors-max-age")
    protected int corsMaxAge = -1;
    @JsonProperty(value="cors-allowed-headers")
    protected String corsAllowedHeaders;
    @JsonProperty(value="cors-allowed-methods")
    protected String corsAllowedMethods;
    @JsonProperty(value="cors-exposed-headers")
    protected String corsExposedHeaders;
    @JsonProperty(value="expose-token")
    protected boolean exposeToken;
    @JsonProperty(value="bearer-only")
    protected boolean bearerOnly;
    @JsonProperty(value="autodetect-bearer-only")
    protected boolean autodetectBearerOnly;
    @JsonProperty(value="enable-basic-auth")
    protected boolean enableBasicAuth;
    @JsonProperty(value="public-client")
    protected boolean publicClient;
    @JsonProperty(value="credentials")
    protected Map<String, Object> credentials = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    @JsonProperty(value="redirect-rewrite-rules")
    protected Map<String, String> redirectRewriteRules;
    @JsonProperty(value="realm")
    protected String realm;
    @JsonProperty(value="realm-public-key")
    protected String realmKey;
    @JsonProperty(value="auth-server-url")
    protected String authServerUrl;
    @JsonProperty(value="ssl-required")
    protected String sslRequired;
    @JsonProperty(value="provider-url")
    protected String providerUrl;
    @JsonProperty(value="client-id")
    protected String clientId;
    @JsonProperty(value="token-signature-algorithm")
    protected String tokenSignatureAlgorithm = "RS256";
    @JsonProperty(value="scope")
    protected String scope;
    @JsonProperty(value="proxy-url")
    protected String proxyUrl;

    public boolean isAllowAnyHostname() {
        return this.allowAnyHostname;
    }

    public void setAllowAnyHostname(boolean allowAnyHostname) {
        this.allowAnyHostname = allowAnyHostname;
    }

    public boolean isDisableTrustManager() {
        return this.disableTrustManager;
    }

    public void setDisableTrustManager(boolean disableTrustManager) {
        this.disableTrustManager = disableTrustManager;
    }

    public String getTruststore() {
        return this.truststore;
    }

    public void setTruststore(String truststore) {
        this.truststore = truststore;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public void setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
    }

    public String getClientKeystore() {
        return this.clientKeystore;
    }

    public void setClientKeystore(String clientKeystore) {
        this.clientKeystore = clientKeystore;
    }

    public String getClientKeystorePassword() {
        return this.clientKeystorePassword;
    }

    public void setClientKeystorePassword(String clientKeystorePassword) {
        this.clientKeystorePassword = clientKeystorePassword;
    }

    public String getClientKeyPassword() {
        return this.clientKeyPassword;
    }

    public void setClientKeyPassword(String clientKeyPassword) {
        this.clientKeyPassword = clientKeyPassword;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public void setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }

    public boolean isAlwaysRefreshToken() {
        return this.alwaysRefreshToken;
    }

    public void setAlwaysRefreshToken(boolean alwaysRefreshToken) {
        this.alwaysRefreshToken = alwaysRefreshToken;
    }

    public boolean isRegisterNodeAtStartup() {
        return this.registerNodeAtStartup;
    }

    public void setRegisterNodeAtStartup(boolean registerNodeAtStartup) {
        this.registerNodeAtStartup = registerNodeAtStartup;
    }

    public int getRegisterNodePeriod() {
        return this.registerNodePeriod;
    }

    public void setRegisterNodePeriod(int registerNodePeriod) {
        this.registerNodePeriod = registerNodePeriod;
    }

    public String getTokenStore() {
        return this.tokenStore;
    }

    public void setTokenStore(String tokenStore) {
        this.tokenStore = tokenStore;
    }

    public String getTokenCookiePath() {
        return this.tokenCookiePath;
    }

    public void setTokenCookiePath(String tokenCookiePath) {
        this.tokenCookiePath = tokenCookiePath;
    }

    public String getPrincipalAttribute() {
        return this.principalAttribute;
    }

    public void setPrincipalAttribute(String principalAttribute) {
        this.principalAttribute = principalAttribute;
    }

    public Boolean getTurnOffChangeSessionIdOnLogin() {
        return this.turnOffChangeSessionIdOnLogin;
    }

    public void setTurnOffChangeSessionIdOnLogin(Boolean turnOffChangeSessionIdOnLogin) {
        this.turnOffChangeSessionIdOnLogin = turnOffChangeSessionIdOnLogin;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public void setProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
    }

    public int getTokenMinimumTimeToLive() {
        return this.tokenMinimumTimeToLive;
    }

    public void setTokenMinimumTimeToLive(int tokenMinimumTimeToLive) {
        this.tokenMinimumTimeToLive = tokenMinimumTimeToLive;
    }

    public int getMinTimeBetweenJwksRequests() {
        return this.minTimeBetweenJwksRequests;
    }

    public void setMinTimeBetweenJwksRequests(int minTimeBetweenJwksRequests) {
        this.minTimeBetweenJwksRequests = minTimeBetweenJwksRequests;
    }

    public int getPublicKeyCacheTtl() {
        return this.publicKeyCacheTtl;
    }

    public void setPublicKeyCacheTtl(int publicKeyCacheTtl) {
        this.publicKeyCacheTtl = publicKeyCacheTtl;
    }

    public boolean isPkce() {
        return this.pkce;
    }

    public void setPkce(boolean pkce) {
        this.pkce = pkce;
    }

    public boolean isIgnoreOAuthQueryParameter() {
        return this.ignoreOAuthQueryParameter;
    }

    public void setIgnoreOAuthQueryParameter(boolean ignoreOAuthQueryParameter) {
        this.ignoreOAuthQueryParameter = ignoreOAuthQueryParameter;
    }

    public boolean isVerifyTokenAudience() {
        return this.verifyTokenAudience;
    }

    public void setVerifyTokenAudience(boolean verifyTokenAudience) {
        this.verifyTokenAudience = verifyTokenAudience;
    }

    public String getSslRequired() {
        return this.sslRequired;
    }

    public void setSslRequired(String sslRequired) {
        this.sslRequired = sslRequired;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getRealmKey() {
        return this.realmKey;
    }

    public void setRealmKey(String realmKey) {
        this.realmKey = realmKey;
    }

    public String getAuthServerUrl() {
        return this.authServerUrl;
    }

    public void setAuthServerUrl(String authServerUrl) {
        this.authServerUrl = authServerUrl;
    }

    public String getProviderUrl() {
        return this.providerUrl;
    }

    public void setProviderUrl(String providerUrl) {
        this.providerUrl = providerUrl;
    }

    public int getConfidentialPort() {
        return this.confidentialPort;
    }

    public void setConfidentialPort(int confidentialPort) {
        this.confidentialPort = confidentialPort;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getResourceName() {
        return this.resource != null ? this.resource : this.clientId;
    }

    public boolean isUseResourceRoleMappings() {
        return this.useResourceRoleMappings;
    }

    public void setUseResourceRoleMappings(boolean useResourceRoleMappings) {
        this.useResourceRoleMappings = useResourceRoleMappings;
    }

    public boolean isUseRealmRoleMappings() {
        return this.useRealmRoleMappings;
    }

    public void setUseRealmRoleMappings(boolean useRealmRoleMappings) {
        this.useRealmRoleMappings = useRealmRoleMappings;
    }

    public boolean isCors() {
        return this.cors;
    }

    public void setCors(boolean cors) {
        this.cors = cors;
    }

    public int getCorsMaxAge() {
        return this.corsMaxAge;
    }

    public void setCorsMaxAge(int corsMaxAge) {
        this.corsMaxAge = corsMaxAge;
    }

    public String getCorsAllowedHeaders() {
        return this.corsAllowedHeaders;
    }

    public void setCorsAllowedHeaders(String corsAllowedHeaders) {
        this.corsAllowedHeaders = corsAllowedHeaders;
    }

    public String getCorsAllowedMethods() {
        return this.corsAllowedMethods;
    }

    public void setCorsAllowedMethods(String corsAllowedMethods) {
        this.corsAllowedMethods = corsAllowedMethods;
    }

    public String getCorsExposedHeaders() {
        return this.corsExposedHeaders;
    }

    public void setCorsExposedHeaders(String corsExposedHeaders) {
        this.corsExposedHeaders = corsExposedHeaders;
    }

    public boolean isExposeToken() {
        return this.exposeToken;
    }

    public void setExposeToken(boolean exposeToken) {
        this.exposeToken = exposeToken;
    }

    public boolean isBearerOnly() {
        return this.bearerOnly;
    }

    public void setBearerOnly(boolean bearerOnly) {
        this.bearerOnly = bearerOnly;
    }

    public boolean isAutodetectBearerOnly() {
        return this.autodetectBearerOnly;
    }

    public void setAutodetectBearerOnly(boolean autodetectBearerOnly) {
        this.autodetectBearerOnly = autodetectBearerOnly;
    }

    public boolean isEnableBasicAuth() {
        return this.enableBasicAuth;
    }

    public void setEnableBasicAuth(boolean enableBasicAuth) {
        this.enableBasicAuth = enableBasicAuth;
    }

    public Map<String, Object> getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Map<String, Object> credentials) {
        this.credentials = credentials;
    }

    public boolean isPublicClient() {
        return this.publicClient;
    }

    public void setPublicClient(boolean publicClient) {
        this.publicClient = publicClient;
    }

    public Map<String, String> getRedirectRewriteRules() {
        return this.redirectRewriteRules;
    }

    public void setRedirectRewriteRules(Map<String, String> redirectRewriteRules) {
        this.redirectRewriteRules = redirectRewriteRules;
    }

    public String getTokenSignatureAlgorithm() {
        return this.tokenSignatureAlgorithm;
    }

    public void setTokenSignatureAlgorithm(String tokenSignatureAlgorithm) {
        this.tokenSignatureAlgorithm = tokenSignatureAlgorithm;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }
}

