/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.security.PublicKey;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.client.methods.HttpGet;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.Oidc;
import org.wildfly.security.http.oidc.OidcClientConfiguration;
import org.wildfly.security.http.oidc.OidcException;
import org.wildfly.security.http.oidc.PublicKeyLocator;
import org.wildfly.security.jose.jwk.JWK;
import org.wildfly.security.jose.jwk.JsonWebKeySet;
import org.wildfly.security.jose.jwk.JsonWebKeySetUtil;

class JWKPublicKeyLocator
implements PublicKeyLocator {
    private Map<String, PublicKey> currentKeys = new ConcurrentHashMap<String, PublicKey>();
    private volatile int lastRequestTime = 0;

    JWKPublicKeyLocator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PublicKey getPublicKey(String kid, OidcClientConfiguration oidcClientConfiguration) {
        int currentTime;
        int minTimeBetweenRequests = oidcClientConfiguration.getMinTimeBetweenJwksRequests();
        int publicKeyCacheTtl = oidcClientConfiguration.getPublicKeyCacheTtl();
        PublicKey publicKey = this.lookupCachedKey(publicKeyCacheTtl, currentTime = JWKPublicKeyLocator.getCurrentTime(), kid);
        if (publicKey != null) {
            return publicKey;
        }
        JWKPublicKeyLocator jWKPublicKeyLocator = this;
        synchronized (jWKPublicKeyLocator) {
            currentTime = JWKPublicKeyLocator.getCurrentTime();
            if (currentTime > this.lastRequestTime + minTimeBetweenRequests) {
                this.sendRequest(oidcClientConfiguration);
                this.lastRequestTime = currentTime;
            } else {
                ElytronMessages.log.debug("Won't send request to jwks url. Last request time was " + this.lastRequestTime);
            }
            return this.lookupCachedKey(publicKeyCacheTtl, currentTime, kid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(OidcClientConfiguration oidcClientConfiguration) {
        JWKPublicKeyLocator jWKPublicKeyLocator = this;
        synchronized (jWKPublicKeyLocator) {
            this.sendRequest(oidcClientConfiguration);
            this.lastRequestTime = JWKPublicKeyLocator.getCurrentTime();
        }
    }

    private PublicKey lookupCachedKey(int publicKeyCacheTtl, int currentTime, String kid) {
        if (this.lastRequestTime + publicKeyCacheTtl > currentTime && kid != null) {
            return this.currentKeys.get(kid);
        }
        return null;
    }

    private void sendRequest(OidcClientConfiguration oidcClientConfiguration) {
        if (ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.trace("Going to send request to retrieve new set of public keys for client " + oidcClientConfiguration.getResourceName());
        }
        HttpGet getMethod = new HttpGet(oidcClientConfiguration.getJwksUrl());
        try {
            JsonWebKeySet jwks = Oidc.sendJsonHttpRequest(oidcClientConfiguration, getMethod, JsonWebKeySet.class);
            Map<String, PublicKey> publicKeys = JsonWebKeySetUtil.getKeysForUse(jwks, JWK.Use.SIG);
            if (ElytronMessages.log.isDebugEnabled()) {
                ElytronMessages.log.debug("Public keys successfully retrieved for client " + oidcClientConfiguration.getResourceName() + ". New kids: " + publicKeys.keySet().toString());
            }
            this.currentKeys.clear();
            this.currentKeys.putAll(publicKeys);
        }
        catch (OidcException e) {
            ElytronMessages.log.error("Error when sending request to retrieve public keys", e);
        }
    }

    private static int getCurrentTime() {
        return (int)(System.currentTimeMillis() / 1000L);
    }
}

