/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.Oidc;
import org.wildfly.security.http.oidc.OidcJsonConfiguration;

public class HttpClientBuilder {
    private KeyStore truststore;
    private boolean disableTrustManager;
    private boolean disableCookieCache = true;
    private KeyStore clientKeyStore;
    private String clientPrivateKeyPassword;
    private int connectionPoolSize = 100;
    protected int maxPooledPerRoute = 0;
    private HostnameVerificationPolicy policy = HostnameVerificationPolicy.WILDCARD;
    private HttpHost proxyHost;
    private HostnameVerifier verifier = null;
    private SSLContext sslContext;
    private long connectionTimeToLive = -1L;
    private TimeUnit connectionTimeToLiveUnit = TimeUnit.MILLISECONDS;
    private long socketTimeout = -1L;
    private TimeUnit socketTimeoutUnits = TimeUnit.MILLISECONDS;
    private long establishConnectionTimeout = -1L;
    private TimeUnit establishConnectionTimeoutUnits = TimeUnit.MILLISECONDS;

    public HttpClientBuilder setDisableTrustManager() {
        this.disableTrustManager = true;
        return this;
    }

    public HttpClientBuilder setDisableCookieCache(boolean disable) {
        this.disableCookieCache = disable;
        return this;
    }

    public HttpClientBuilder setKeyStore(KeyStore keyStore, String password) {
        this.clientKeyStore = keyStore;
        this.clientPrivateKeyPassword = password;
        return this;
    }

    public HttpClientBuilder setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
        return this;
    }

    public HttpClientBuilder setHostnameVerification(HostnameVerificationPolicy policy) {
        this.policy = policy;
        return this;
    }

    public HttpClientBuilder setTrustStore(KeyStore truststore) {
        this.truststore = truststore;
        return this;
    }

    public HttpClientBuilder setConnectionTimeToLive(long timeToLive, TimeUnit timeToLiveUnit) {
        this.connectionTimeToLive = timeToLive;
        this.connectionTimeToLiveUnit = timeToLiveUnit;
        return this;
    }

    public HttpClientBuilder setMaxPooledPerRoute(int maxPooledPerRoute) {
        this.maxPooledPerRoute = maxPooledPerRoute;
        return this;
    }

    public HttpClientBuilder setSocketTimeout(long timeout, TimeUnit unit) {
        this.socketTimeout = timeout;
        this.socketTimeoutUnits = unit;
        return this;
    }

    public HttpClientBuilder setEstablishConnectionTimeout(long timeout, TimeUnit unit) {
        this.establishConnectionTimeout = timeout;
        this.establishConnectionTimeoutUnits = unit;
        return this;
    }

    public HttpClient build() {
        HostnameVerifier verifier = null;
        if (this.verifier != null) {
            verifier = new VerifierWrapper(this.verifier);
        } else {
            switch (this.policy) {
                case ANY: {
                    verifier = new NoopHostnameVerifier();
                    break;
                }
                case WILDCARD: {
                    verifier = new DefaultHostnameVerifier();
                }
            }
        }
        try {
            HttpClientConnectionManager connectionManager;
            SSLConnectionSocketFactory sslSocketFactory = null;
            SSLContext theContext = this.sslContext;
            if (this.disableTrustManager) {
                theContext = SSLContext.getInstance("TLS");
                theContext.init(null, new TrustManager[]{new PassthroughTrustManager()}, new SecureRandom());
                verifier = new NoopHostnameVerifier();
                sslSocketFactory = new SSLConnectionSocketFactory(theContext, verifier);
            } else if (theContext != null) {
                sslSocketFactory = new SSLConnectionSocketFactory(theContext, verifier);
            } else if (this.clientKeyStore != null || this.truststore != null) {
                sslSocketFactory = new SSLConnectionSocketFactory(SSLContexts.custom().setProtocol("TLS").setSecureRandom(null).loadKeyMaterial(this.clientKeyStore, this.clientPrivateKeyPassword != null ? this.clientPrivateKeyPassword.toCharArray() : null).loadTrustMaterial(this.truststore, null).build(), verifier);
            } else {
                SSLContext tlsContext = SSLContext.getInstance("TLS");
                tlsContext.init(null, null, null);
                sslSocketFactory = new SSLConnectionSocketFactory(tlsContext, verifier);
            }
            Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)sslSocketFactory)).build();
            if (this.connectionPoolSize > 0) {
                PoolingHttpClientConnectionManager pcm = new PoolingHttpClientConnectionManager(registry, null, null, null, this.connectionTimeToLive, this.connectionTimeToLiveUnit);
                pcm.setMaxTotal(this.connectionPoolSize);
                if (this.maxPooledPerRoute == 0) {
                    this.maxPooledPerRoute = this.connectionPoolSize;
                }
                pcm.setDefaultMaxPerRoute(this.maxPooledPerRoute);
                connectionManager = pcm;
            } else {
                connectionManager = new BasicHttpClientConnectionManager(registry);
            }
            org.apache.http.impl.client.HttpClientBuilder clientBuilder = org.apache.http.impl.client.HttpClientBuilder.create();
            int socketTimeoutMillis = (int)this.socketTimeoutUnits.toMillis(this.socketTimeout);
            if (socketTimeoutMillis > 0) {
                clientBuilder.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(socketTimeoutMillis).build());
            }
            clientBuilder.setConnectionManager(connectionManager);
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
            if (this.proxyHost != null) {
                requestConfigBuilder.setProxy(this.proxyHost);
            }
            if (socketTimeoutMillis > -1) {
                requestConfigBuilder.setSocketTimeout(socketTimeoutMillis);
            }
            if (this.establishConnectionTimeout > -1L) {
                requestConfigBuilder.setConnectTimeout((int)this.establishConnectionTimeoutUnits.toMillis(this.establishConnectionTimeout));
            }
            clientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
            if (this.disableCookieCache) {
                clientBuilder.setDefaultCookieStore(new CookieStore(){

                    @Override
                    public void addCookie(Cookie cookie) {
                    }

                    @Override
                    public List<Cookie> getCookies() {
                        return Collections.emptyList();
                    }

                    @Override
                    public boolean clearExpired(Date date) {
                        return false;
                    }

                    @Override
                    public void clear() {
                    }
                });
            }
            return clientBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public HttpClient build(OidcJsonConfiguration oidcClientConfig) {
        String clientKeystore;
        this.setDisableCookieCache(true);
        String truststorePath = oidcClientConfig.getTruststore();
        if (truststorePath != null) {
            truststorePath = Oidc.EnvUtil.replace(truststorePath);
            String truststorePassword = oidcClientConfig.getTruststorePassword();
            try {
                this.truststore = HttpClientBuilder.loadKeyStore(truststorePath, truststorePassword);
            }
            catch (Exception e) {
                throw ElytronMessages.log.unableToLoadKeyStore(e);
            }
        }
        if ((clientKeystore = oidcClientConfig.getClientKeystore()) != null) {
            clientKeystore = Oidc.EnvUtil.replace(clientKeystore);
            String clientKeystorePassword = oidcClientConfig.getClientKeystorePassword();
            try {
                KeyStore clientCertKeystore = HttpClientBuilder.loadKeyStore(clientKeystore, clientKeystorePassword);
                this.setKeyStore(clientCertKeystore, clientKeystorePassword);
            }
            catch (Exception e) {
                throw ElytronMessages.log.unableToLoadTrustStore(e);
            }
        }
        int size = 10;
        if (oidcClientConfig.getConnectionPoolSize() > 0) {
            size = oidcClientConfig.getConnectionPoolSize();
        }
        if (oidcClientConfig.getConnectionTimeoutMillis() > 0) {
            this.setEstablishConnectionTimeout(oidcClientConfig.getConnectionTimeoutMillis(), this.establishConnectionTimeoutUnits);
        }
        if (oidcClientConfig.getConnectionTtlMillis() > 0) {
            this.setConnectionTimeToLive(oidcClientConfig.getConnectionTtlMillis(), this.connectionTimeToLiveUnit);
        }
        if (oidcClientConfig.getSocketTimeoutMillis() > 0) {
            this.setSocketTimeout(oidcClientConfig.getSocketTimeoutMillis(), this.socketTimeoutUnits);
        }
        HostnameVerificationPolicy policy = HostnameVerificationPolicy.WILDCARD;
        if (oidcClientConfig.isAllowAnyHostname()) {
            policy = HostnameVerificationPolicy.ANY;
        }
        this.setConnectionPoolSize(size);
        this.setHostnameVerification(policy);
        if (oidcClientConfig.isDisableTrustManager()) {
            this.setDisableTrustManager();
        } else {
            this.setTrustStore(this.truststore);
        }
        this.configureProxyForAuthServerIfProvided(oidcClientConfig);
        return this.build();
    }

    private void configureProxyForAuthServerIfProvided(OidcJsonConfiguration adapterConfig) {
        if (adapterConfig == null || adapterConfig.getProxyUrl() == null || adapterConfig.getProxyUrl().trim().isEmpty()) {
            return;
        }
        URI uri = URI.create(adapterConfig.getProxyUrl());
        this.proxyHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
    }

    private static KeyStore loadKeyStore(String filename, String password) throws Exception {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream trustStream = null;
        if (filename.startsWith("classpath:")) {
            String resourcePath = filename.replace("classpath:", "");
            if (Thread.currentThread().getContextClassLoader() != null) {
                trustStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);
            }
            if (trustStream == null) {
                trustStream = HttpClientBuilder.class.getResourceAsStream(resourcePath);
            }
            if (trustStream == null) {
                throw ElytronMessages.log.unableToFindTrustStoreFile(filename);
            }
        } else {
            trustStream = new FileInputStream(filename);
        }
        try (FileInputStream is = trustStream;){
            trustStore.load(is, password.toCharArray());
        }
        return trustStore;
    }

    private static class PassthroughTrustManager
    implements X509TrustManager {
        private PassthroughTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    static class VerifierWrapper
    implements HostnameVerifier {
        protected HostnameVerifier verifier;

        VerifierWrapper(HostnameVerifier verifier) {
            this.verifier = verifier;
        }

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return this.verifier.verify(s, sslSession);
        }
    }

    public static enum HostnameVerificationPolicy {
        ANY,
        WILDCARD;

    }
}

